/******************************************************************************
*
*    Receive a message from a tcp socket
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  tcp_recv.c,v
  1994/01/25 15:08:06
  1.5
  Exp
  lamberts
 
  Authors: Stephan Plogstie"s, Stefan Lamberts

  Description: Receive a message from a tcp socket

  Available functions from this module:

******************************************************************************/
#ifndef lint
static char rcs_id[] = "tcp_recv.c,v 1.5 1994/01/25 15:08:06 lamberts Exp";
#endif


#include <errno.h>
#include <unistd.h>


int _tcp_recv
#ifdef ANSI
(int fd, void *buf, long len)
#else
(fd, buf, len)
int fd;
void *buf;
long len;
#endif
{
  long  br = 0;                 /* Number of bytes read */
  long bl = len;                /* Number of bytes not yet read */
  char *bp = (char *)buf;       /* Pointer to the location in the buffer
                                   where to start the next read() */


  while (bl > 0)
  {
    if ((br = read(fd, (void *)bp, (unsigned int)bl)) < 0)
    {
      if (errno != EWOULDBLOCK) /* If read() would block try again */
        return (-1);
    }
    else if (br == 0)
    {
      errno = ESHUTDOWN;
      return (-1);
    }
    bl -= br;
    bp += br;
  }
  return(0);
}
  

