/******************************************************************************
*
*    Initalize the tcp layer
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  tcp_init.c,v
  1994/11/25 14:56:36
  1.12
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Initalize the tcp layer

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "tcp_init.c,v 1.12 1994/11/25 14:56:36 lamberts Exp";
#endif

#define CHECK_NODELAY

#ifdef HP_UX
#define TCP_IOCTL
#endif
#ifdef SUN_OS5
#define TCP_IOCTL
#endif

#include <sys/types.h>
#include <sys/socket.h>

#ifdef TCP_IOCTL
#include <sys/ioctl.h>
#else
#include <fcntl.h>
#endif

#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <signal.h>
#include <unistd.h>

#include "../include/config.h"

int __tcpbufsize = DEFAULT_TCP_BUFFER_SIZE;


int config_socket(fd)
int fd;
{
#ifdef TCP_IOCTL                /* HP_UX, SUN_OS5 */
  int ioctl_adr;
#endif
  int nodelay;
  
  /* Set NODELAY */
  nodelay = 1;
  if ((setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,(char *)&nodelay,sizeof(int)) < 0)
      ||
      (setsockopt(fd,SOL_SOCKET,SO_RCVBUF,(char *)&__tcpbufsize,sizeof(int))
      < 0)
      ||
      (setsockopt(fd,SOL_SOCKET,SO_SNDBUF,(char *)&__tcpbufsize,sizeof(int))
       < 0))
    return (-1);

#ifdef TCP_BUFSIZE_DBG
{
  int opt, optlen;
     
  optlen =sizeof(int);
  getsockopt(fd,SOL_SOCKET,SO_SNDBUF,(char *)&opt,&optlen);
  _dbgmsg("SO_SNDBUF = %d",opt);
  
  optlen =sizeof(int);
  getsockopt(fd,SOL_SOCKET,SO_RCVBUF,(char *)&opt,&optlen);
  _dbgmsg("SO_RCVBUF = %d",opt);
}
#endif /* TCP_BUFSIZE_DBG */

  /***
   *** Set the socket to asynchronous IO
   *** I.e. a SIGIO will be raised if the socket is ready for reading
   ***/
#ifdef TCP_IOCTL                /* HP_UX, SUN_OS5 */
	ioctl_adr = getpid();

	if (ioctl(fd, SIOCSPGRP, (char *) &ioctl_adr) < 0) {
		return (-1);
	}

	ioctl_adr = 1;

	if (ioctl(fd, FIOASYNC, (char *) &ioctl_adr) < 0) {
		return (-1);
	}
#else  /* SUN_OS4 SGI_IRIX ALPHA_AXP*/
  if (fcntl(fd, F_SETOWN, getpid()) < 0)
    return (-1);

  if (fcntl(fd, F_SETFL, FASYNC) < 0)
    return (-1);
#endif  

  return (0);
}



/*
* This function uses the two defines START_PORT and END_PORT for the choose
* of the communication port. It returns the socket_fd if everything was good
* else the defines SOCKET_ERROR, SOCKET_BIND_ERROR and FCNTL_ERROR are
* returned to mark the error.
*/
int _tcp_socket
#ifdef ANSI
(struct sockaddr_in *adr)
#else
(adr)
struct sockaddr_in *adr;
#endif
{
  int  fd;
  int  bind_result;
  int port;

  /***
   *** Create a socket
   ***/
  if (((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) ||
      (config_socket(fd) < 0))
    return(-1);

  /***
   *** Bind socket to a port
   ***/
  adr->sin_family = AF_INET;

  for(port = START_PORT; port <= END_PORT; port++)
  {
    adr->sin_port = htons(port);
    if ((bind_result = bind(fd,
                            (struct sockaddr *)adr,
                            sizeof(struct sockaddr_in))) == 0)
      break;
  }
  if (bind_result < 0)
    return (-1);
  
  /***
   *** Listen for connections on the socket
   ***/
  if (listen(fd, MAXSOCKCONN) < 0)
    return (-1);

  return(fd);
}




int _tcp_accept
#ifdef ANSI 
(int fd, struct sockaddr_in *adr)
#else
(fd, adr)
int fd;
struct sockaddr_in *adr;
#endif
{
  int nodelay = 1;
  int addrlen;
  int res;

  addrlen = sizeof(struct sockaddr_in);
  res = accept(fd, (struct sockaddr *)adr, &addrlen);

  setsockopt(res,IPPROTO_TCP,TCP_NODELAY,(char *)&nodelay,sizeof(int));

  return (res);
}

/*
* tcp_connect receives a filled structure sockaddr_in and returns a socket
* that is connected to this address.
*/
int _tcp_connect
#ifdef ANSI
(struct sockaddr_in *sad)
#else
(sad)
struct sockaddr_in  *sad;
#endif
{
  int   fd;
#ifdef BSD_SIG
  int oldmask;
#else
  sigset_t set;
  sigset_t oset;
#endif

  /* LAMBO: Was passiert mit der Signalmaske, wenn diese Prozedur
     innerhalb einer SIGIO Behandlung aufgerufen wird? */
  
  /* Block SIGIO  */
#ifdef BSD_SIG
  oldmask = sigblock(sigmask(SIGIO));
#else  
  sigemptyset(&set);
  sigaddset(&set,SIGIO);
  sigprocmask(SIG_BLOCK,&set,&oset);
#endif

  if (((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) ||
      (config_socket(fd) < 0) ||
      (connect(fd, (struct sockaddr *)sad, sizeof(struct sockaddr_in)) < 0))
  {    
#ifdef BSD_SIG
    sigsetmask(oldmask);
#else
    sigprocmask(SIG_SETMASK,&oset,(sigset_t *)0);
#endif
    return (-1);
  }

#ifdef BSD_SIG
  sigsetmask(oldmask);
#else
  sigprocmask(SIG_SETMASK,&oset,(sigset_t *)0);
#endif
  
  return(fd);
}


