/******************************************************************************
*
*    Startup code for the controlling process
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  contrproc.c,v
  1994/04/28 13:37:42
  1.7
  Exp
  plogstie
 
  Authors: Stefan Lamberts, Susanna Schink

  Description:

  This file contains the code that is executed as controlling process
  if the application was compiled with the -nx switch.

  Available functions from this module:
  
  int _contrproc(argc, argv, envp)
  int argc;
  char **argv;
  char **envp;

******************************************************************************/
#ifndef lint
static char rcs_id[] = "contrproc.c,v 1.7 1994/04/28 13:37:42 plogstie Exp";
#endif

  
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include "../include/sys/nxerrno.h"
#include "../include/nxmalloc.h"

extern long __numnodes();
extern long nx_initve();
extern long nx_loadve();
extern void nx_perror();
extern long nx_waitall();

#ifdef SUN_OS4
extern long strtol();
#endif

/**************************************************************************
 * Remove initialisation arguments
 *************************************************************************/
/* num MUST be greater than *argc:  (num > *argc) */
static void
#ifdef ANSI
rm_arg(int *argc, char **argv, char **arg, int num)
#else
rm_arg(argc, argv, argi, num)
long *argc;
char **argv;
int argi;
int num;
#endif
/*************************************************************************/
{
  int i;
  
  /* cont the number of arguments before arg */
  for (i = 0; i < *argc; i++)
  {
    if (i >= (argi + num))
    {
      argv[i-num] = argv[i];
    }
  }
  *argc -= num;
}


/**************************************************************************
 * read the specified nodes from the command-line
 *************************************************************************/
static int
#ifdef ANSI
parse_on_list(char *nodespec, long **list)
#else
parse_on_list(nodespec, list)
char *nodespec;
long **list;
#endif
/*************************************************************************/   
/* This is the implementaion of finite state machine to scan a node
 * specification
 *
 * The state machine has 4 states; 0 is the initial state;
 * 3 is the final state;
 * The following table shows the state transition function and the
 * actions that are taken. "N" is a  valid node number, i.e. 'n' or a
 * positiv integer
 *
 *         |                          State
 *  Input  |         0        |         1         |           2          |
 * --------+------------------+-------------------+----------------------+
 *   "N"   |         1        |       Error       |         Error        |
 *         | read node number |                   |                      |
 * --------+------------------+-------------------+----------------------+
 *   ","   |       Error      |         0         |           0          |
 *         |                  | enter node number | enter list of node   |
 *         |                  | in node list      | numbers in node list |
 * --------+------------------+-------------------+----------------------+
 *   "..N" |       Error      |         2         |         Error        |
 *         |                  | read node number  |                      |
 * --------+------------------+-------------------+----------------------+
 *   "\0"  |       Error      |         3         |           3          |
 * --------+------------------+-------------------+----------------------+
 */
{
  char *tmpstr;
  char *resstr;
  int count = 0;
  long *tmplist;
  long i;
  long tmp;
  long fn;
  long ln;
  int state = 0;


  if ((tmplist = (long *)malloc((size_t)0)) == NULL)
    return -1;
  
  tmpstr = nodespec;    /* set tmpstr to the beginning of the node
                         * specification string nodespec */
  

  while (state != 3)
  {
    switch (state)
    {
      
    case 0:
      /* valid input is a number or 'n' */
      /* get the number of the node */
      if (*tmpstr == 'n')
      {
        tmpstr++;
        fn = __numnodes() - 1;
      }
      else
      {
        fn = strtol(tmpstr,&resstr,10);
        if (((fn == 0) && (resstr == tmpstr)) || /* no number */
            (fn < 0))    /* nodenumber less than 0 */
        {
          errno = EPBADNODE;
          return -1;
        }
        tmpstr = resstr;
      }
      state = 1;
      break;

    case 1:
      /* valid input is ".." followed by a nodenumber, ',' or '\0' */

      switch (*tmpstr)
      {

      case '.':      /* input could be ".." followed by a
                     * nodenumber */
        tmpstr++;
        if (*tmpstr++ != '.')
        {  /* there must be a second '.' */
          errno = EPBADNODE;
          return -1;
        }
  
        /* read node number */
        if (*tmpstr == 'n')
        {
          tmpstr++;
          ln = __numnodes() - 1;
        }
        else {
          ln = strtol(tmpstr,&resstr,10);
          if (((ln == 0) && (resstr == tmpstr)) || /* no number */
              (ln < 0))    /* nodenumber less than 0 */
          {
            errno = EPBADNODE;
            return -1;
          }
          tmpstr = resstr;
        }
      
        if (fn > ln)
        {    /* decreasing node numbers */
          tmp = fn;
          fn = ln;
          ln = tmp;
        }
        state = 2;
        break;

      case ',':      /* input is ',' */
        tmpstr++;
        /* enter node in nodelist */
        count++;
        if ((tmplist = (long *)realloc((void *)tmplist,
                                       (size_t)(count*sizeof(long))))
            == (long *)NULL)
          return -1;
        tmplist[count-1] = fn;
        state = 0;
        break;

      case '\0':      /* input is '\0' */
        /* enter node in nodelist */
        count++;
        if ((tmplist = (long *)realloc((void *)tmplist,
                                       (size_t)(count*sizeof(long))))
            == (long *)NULL)
          return -1;
        tmplist[count-1] = fn;
        state = 3;
        break;
      default:
        errno = EPBADNODE;
        return -1;
      }
      break;

    case 2:
      /* valid input is ',' or '\0' */

      switch (*tmpstr)
      {
        
      case ',':      /* input is ',' */
        tmpstr++;
        /* enter list of nodes in nodelist */
        for (i = fn; i <= ln; i++)
        {
          count++;
          if ((tmplist = (long *)realloc((void *)tmplist,
                                         (size_t)(count*sizeof(long))))
              == (long *)NULL)
            return -1;
          tmplist[count-1] = i;
        }
        state = 0;
        break;

      case '\0':
        /* enter list of nodes in nodelist */
        for (i = fn; i <= ln; i++)
        {
          count++;
          if ((tmplist = (long *)realloc((void *)tmplist,
                                         (size_t)(count*sizeof(long))))
              == (long *)NULL)
            return -1;
          tmplist[count-1] = i;
        }
        state = 3;
        break;
      default:
        errno = EPBADNODE;
        return -1;
      }
      break;
    default:
      errno = EPALLOCERR;
      return -1;
    }
  }

  if (*list != (long *)0)
    free((void *)*list); /* free old list if any */
  *list = tmplist;    /* set new list */
  return count;
}


/*************************************************************************/
static int
#ifdef ANSI
nxload_args(long *argc,
            char **argv,
            long *ptype,
            long **nodelist,
            long *nodenumber)
#else
nxload_args(argc, argv, ptype, nodelist, nodenumber)
long *argc;
char **argv;
long *ptype;
long **nodelist;
long *nodenumber;
#endif
     /*************************************************************************/
{
  int argi;                      /* argument index */
  char *tmpstr;
  
  for (argi = *argc - 1; argi > 0; argi--)
  {                              /* parse the command line in reverse order */
    if (!strcmp(argv[argi],"-on"))
    {                            /* nodespec */
      if (argi == (*argc - 1))
      {                          /* the required argument is missing */
        errno = EPBADNODE;
        return -1;
      }
      if ((*nodenumber = parse_on_list(argv[argi+1],nodelist)) < 0)
        return -1;
      rm_arg(argc,argv,argi,2);
    }
    
    else if (!strcmp(argv[argi],"-pt"))
    {                            /* ptype */
      if (argi == (*argc - 1))
      {                          /* the required argument is missing */
        errno = EQPID;
        return -1;
      }
      if ((*ptype = strtol(argv[argi+1],&tmpstr,10)) == 0)
      {
        if ((tmpstr == argv[argi+1]) || (*tmpstr != '\0'))
        {                        /* bogous ptype specification */
          errno = EQPID;
          return -1;
        }
      }
      if (*ptype < 0)
      {                          /* bogous ptype specification */
        errno = EQPID;
        return -1;
      }
      rm_arg(argc,argv,argi,2);
    }
  }
  return 0;
}




/*************************************************************************/
int
#ifdef ANSI
_contrproc(int argc, char **argv, char **envp)
#else
_contrproc(argc, argv, envp)
int argc;
char **argv;
char **envp;
#endif
/*************************************************************************/
{
  int first_appl = 1;
  
  int i;
  int j;
  int k;
  
  char **apargv;
  char **newapargv;
  long apargc;
  
  long *pid_list;
  
  char*path;
  long *node_list;
  long node_number;
  long ptype;


  /* start all applications that are separated by "\;" */
  for(j = 0; j < argc; j = i + 1)
  {

    /**
     ** Set number of nodes, list of nodes and ptype to default values
     **/
    node_number = -1;
    node_list = (long *)0;
    ptype = 0;

    /**
     ** Find next occurence of ";" if any
     **/
    for (i=j; i < argc; i++)
      if (!strcmp(argv[i],";"))
        break;
    
    /**
     ** Set the application's argument vector and argument counter to the
     ** appropriate values
     **/
    apargc = i - j;
    apargv = &argv[j];
    

    /**
     ** call nx_initve() if it wasn't allready called
     **/
    if (first_appl) {
      if (nx_initve((char *)0,(long)0,(char *)0,&apargc,apargv) < 0)
      {
        nx_perror(argv[0]);
        return (-1);
      }
      first_appl = 0;
    }
    
    /**
     ** Extract application specific switches (-pt -on) from the
     ** argument vector
     **/
    if (nxload_args(&apargc,apargv,&ptype,&node_list,&node_number) < 0)
    {
      nx_perror(argv[0]);
      return (-1);
    }

    /**
     ** Set the parameters for the nx_loadve() call.
     ** Call nx_loadve().
     ** free() temporary allocated parameter.
     **/
    path = apargv[0];
    
    if ((newapargv = (char **)malloc((size_t)(sizeof(char *)*(apargc+1))))
        == (char **)0)
    {
      nx_perror(argv[0]);
      return (-1);
    }

    for (k=0;k<apargc;k++)
      newapargv[k] = apargv[k];

    newapargv[k] = (char *)0;

    if ((pid_list = (long *)malloc((size_t)(sizeof(long)*
                                              (node_number == -1 ?
                                               __numnodes() :
                                               node_number))))
        == (long *)0)
    {
      nx_perror(argv[0]);
      return (-1);
    }

    if (nx_loadve(node_list,
                  node_number,
                  ptype,
                  pid_list,
                  path,
                  newapargv,
                  envp) < 0)
    {
      nx_perror(argv[0]);
      return (-1);
    }
    
    if (node_list != (long *)0)
      free((void *)node_list);
    if (pid_list != (long *)0)
      free((void *)pid_list);
    if (newapargv != (char **)0)
      free((void *)newapargv);
  }
  
  /**
   ** Wait for the application processes to terminate
   **/
  if (nx_waitall() < 0)
  {
    nx_perror(argv[0]);
    return -1;
  }
  
  return 0;
}
