/******************************************************************************
*
*    Calculate the special argument used to identify the application process
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  calc_arg.c,v
  1994/08/17 14:43:27
  1.5
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description:

  This file contains procedures, which are used to distinguish between
  application processes and controlling process. 

  Available procedures:

  int _calc_applproc_code(argv)
  char **argv;

  int _is_applproc(argc,argv)
  int argc;
  char **argv()

******************************************************************************/
#ifndef lint
static char rcs_id[] = "calc_arg.c,v 1.5 1994/08/17 14:43:27 lamberts Exp";
#endif

#include <stdlib.h>
#include <string.h>

#define NO_ARG 7


/*****************************************************************************
  Calculate a code using the arguments for an application process that allows
  to distinguish between application process and controlling process.

  The calculated code will be returned.
******************************************************************************/
int
#ifdef ANSI
_calc_applproc_code(char **argv);
#else
_calc_applproc_code(argv)
char **argv;
#endif

{
  int i;
  int res = 0;
  char *c;
  
  for (c=argv[0]; *c != '\0'; c++)
    res += (int)*c;

  for (i = 2; i < NO_ARG; i++)
    for (c=argv[i]; *c != '\0'; c++)
      res += (int)*c;

  return res;
}




/*****************************************************************************
  Check weather the calling process is an application process or a controlling
  process.

  If it is an application process 0 will be returned;
  if not 1 will be returned.
******************************************************************************/
int
#ifdef ANSI
_is_applproc(int argc, char **argv);
#else
_is_applproc(argc,argv)
int argc;
char **argv;
#endif

{
  /* application process has at least 7 arguments
   * those are:
   *   - argv[0] : name of the executable
   *   - argv[1] : code to identify an aplication process
   *   - argv[2] : the portnumber of the daemon
   *   - argv[3] : the number of nodes in that application
   *   - argv[4] : the nodenumber of this node
   *   - argv[5] : the ptype of that process
   *   - argv[6] : TCP send and receive buffer size
   *   - argv[7] : a copy of argv[0] in order to restore the argv easier
   */
  if (argc < NO_ARG+1)
    return 0;
  
  /* argv[0] and argv[7] must contain the same string */
  if (strcmp(argv[0],argv[NO_ARG]) != 0)
    return 0;

  /* argv[1] can be calculated from argv */
  if (_calc_applproc_code(argv) != atoi(argv[1]))
    return 0;

  return 1;
}
