/******************************************************************************
*
*    Startup code for application processes
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  applproc.c,v
  1994/12/30 16:34:12
  1.9
  Exp
  lamberts
 
  Authors: Stefan Lamberts, Susanna Schink

  Description:

  This file contains the procedure that initializes the application before
  the users application program is started.

  Available functions from this module:

  int _applproc(argc, argv, envp)
  int argc;
  char **argv;
  char **envp;

******************************************************************************/
#ifndef lint
static char rcs_id[] = "applproc.c,v 1.9 1994/12/30 16:34:12 lamberts Exp";
#endif

#include <sys/types.h>
#include <stdlib.h>

#ifdef HP_UX
#include <malloc.h>             /* For mallopt() */
#endif

#include "../include/nxmalloc.h"

#define NO_ARG 7

extern void __setnode();
extern void __setnumnodes();
extern long __setptype();
extern int  _init_c_buf();
extern int  _init_i_buf();
extern int  _init_m_buf();
extern int  _rel_a_setup();
extern void nx_perror();
extern int  MAIN_TMPL();

extern int __tcpbufsize;


/************************************************************************/
int
#ifdef ANSI
_applproc(int argc, char **argv, char **envp)
#else
_applproc(argc, argv, envp)
int argc;
char **argv;
char **envp;
#endif
/************************************************************************/
{
  int newargc;
  char **newargv;

#ifdef HALTAPPL
  int dbg = 1;
  
  while (dbg);
#endif
  
  /* Block Signals during memmory allocating calls */
#ifdef HP_UX
  if (mallopt(M_BLOCK,1) != 0)
    return (-1);
#endif


  /**
   ** Set number of nodes
   **/
  __setnumnodes(atol(argv[3]));

  /**
   ** Set node number
   **/
  __setnode(atol(argv[4]));

  /**
   ** Set ptype
   **/
  if (__setptype(atol(argv[5])) < 0)
  {
    nx_perror("__setptype()");
    return (-1);
  }

  if ((__tcpbufsize = atoi(argv[6])) <= 0)
  {
    nx_perror("Invalid TCP buffer size");
    return (-1);
  }

  /* Initialize buffer layer */
  if (_init_m_buf() < 0)
  {
    nx_perror("init_m_buf()");
    return (-1);
  }
  if (_init_c_buf() < 0)
  {
    nx_perror("init_c_buf()");
    return (-1);
  }
  if (_init_i_buf() < 0)
  {
    nx_perror("init_i_buf()");
    return (-1);
  }
  
  /* Intialize communication layer */
  if (_rel_a_setup((u_short)atol(argv[2])) < 0)
  {
    nx_perror("_rel_setup()");
    return (-1);
  }  


  /**
   ** Remove the arguments that are needed to set up the application process
   ** form the argument vector
   **/
  newargc = argc - NO_ARG;
  newargv = argv + NO_ARG;

  /**
   ** Start the users application program and return its return value
   **/

  return((int)MAIN_TMPL(newargc, newargv, envp));
}



