/******************************************************************************
*
*    Handle a signal of a remot4e message
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  remote_sig.c,v
  1995/02/06 16:08:50
  1.13
  Exp
  lamberts
 
  Authors: Stephan Plogstie"s, Stefan Lamberts

  Description:

  This file contains the procedure _rem_signal(), which is invoked in case a
  signal was raised indicating the arrival of a remote message. Until no 
  more messages are pending, this procedures selects a socket which is ready
  for reading, reads the message and handles it. 

  Available functions from this module: ...

  int _rem_signal();


******************************************************************************/
#ifndef lint
static char rcs_id[] = "remote_sig.c,v 1.13 1995/02/06 16:08:50 lamberts Exp";
#endif

#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <netdb.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef SUN_OS4
#include <memory.h>             /* Should be included in string.h */
#endif

#ifdef RS6K_AIX
#include <sys/select.h>
#endif

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern void _enter_signal_handler();
extern void _leave_signal_handler();
extern int  _tcp_accept();
extern int  _tcp_connect();
extern int  _tcp_socket();
extern int  _rem_close();
extern int  _rem_recv();
extern int  _rem_set_fdset();
extern int  _update_plistel();
extern void nx_perror();


static rem_addr my_rem_addr;
static int (* rem_handler)();


static int _rem_handle_msg
#ifdef ANSI
(rem_addr *adr)
#else
(adr)
rem_addr *adr;
#endif
{
  msg_desc *msgd;

  if (_rem_recv(adr->sockfd, &msgd) < 0)
  {
    /* switch for the known and other errors */
    switch(errno) {
    case ESHUTDOWN:
    case ECONNRESET:
      /* Socket was closed */
      if (_rem_close(adr) < 0)
        return (-1);
      break;
    default:
      return (-1);
    }
    if (msgd != (msg_desc *)0)
    {
      if (msgd->msg_len != 0)
        free((void *)msgd->msg_ptr);
      free((void *)msgd);
    }
    return(0);
  } 

  if (msgd->msg_type == DOUBLE_CONN)
  {
    /* A double connection was detected and this is the last message
     * form this socket. */
    close(adr->sockfd);
  }

  /* Enter ptype in the address database if its not allread known */
  if (_update_plistel(msgd->s_node,
                      msgd->s_ptype,
                      LOC_REMOTE,
                      adr,
                      (loc_addr *)0,
                      (char *)0,
                      (char *)0,
                      (char *)0,
                      msgd->s_pid) < 0)
    return -1;
    
  if (msgd->msg_type == DOUBLE_CONN)
  {
    free((void *)msgd);
    return (0);
  }
  
  /* Call the message handler */
  return ((* rem_handler)(msgd));
}



/*****************************************************************************/
static int _rem_signal
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  int  sel_result;
  int max_socket;
  fd_set *fdvp;
  fd_set fdv;
  struct timeval timeout;
  rem_addr adr;
  int i;
  int sr;
  
  int cnt = 0;                 /* Number of received messages */
  
  if(my_rem_addr.sockfd < 0)
  {                             /* Socket wasn't initialized */
    errno = ENOTCONN;
    return (-1);
  }

  timeout.tv_sec = 0;           /* set timeout-value to a minimum */
  timeout.tv_usec = 0;


  do                      /* Receice until no more messages are
                             pending */
  {

    /***
     *** Set the varible that indicates the socktes an which a message can be
     *** received
     ***/
    max_socket = _rem_set_fdset(&fdvp); /* set all sockets into fdvar */
    memcpy((void *)&fdv, (void *)fdvp, sizeof(fd_set));

    /* delete the sockets which this process created with the socket()
     * system call formthe varible */

    if(max_socket >= 0)           /* try to select() only if there are
                                     sockets specified in fdvar */
    {
      if ((sel_result = select(max_socket + 1, &fdv, (fd_set *)0, (fd_set *)0,
                               &timeout)) < 0)
      {
        nx_perror("select()");
        return (-1);
      }
    }
    else
      sel_result = 0;
    for (sr = 0, i = 0; sr < sel_result; sr ++)
    {
      for (; i <= max_socket; i++)
      {
        if (FD_ISSET(i,&fdv))
        {
          if (i == my_rem_addr.sockfd) 
          {
            if ((adr.sockfd = _tcp_accept(my_rem_addr.sockfd, &adr.sad)) < 0)
            {
              nx_perror("_tcp_accept()");
              return(-1);
            }
            adr.stat = ADDR_KNOWN;
          }
          else
          {
            adr.sockfd = i;
            adr.stat = ADDR_UNKNOWN;
          }
          
          if (_rem_handle_msg(&adr) < 0)
            return (-1);
          
          cnt++;
        }
      }
    }
  }
  while (sel_result > 0);
  return (cnt);
}





int _rem_open_conn
#ifdef ANSI
(struct sockaddr_in *sad)
#else
(sad)
struct sockaddr_in *sad;
#endif
{
  return(_tcp_connect(sad));
}






static void
#ifdef ANSI
io_handler(void)
#else
io_handler()
#endif
{
  int loc_errno = errno;

  _enter_signal_handler();

  if (_rem_signal() < 0)
  {
    nx_perror("io_handler()");
    exit(-1);
  } 
  errno = loc_errno;
  _leave_signal_handler();
  return;
}




rem_addr *_rem_setup
#ifdef ANSI
(int (*handler)(void))
#else
(handler)
int (*handler)();
#endif
{
  struct hostent *hp;

#ifdef BSD_SIG
  struct sigvec vec;
#else
  struct sigaction  sigact;
#endif

  char hostname[MAXHNAMELEN];

  
  /* Setup SIGIO Handler */

#ifdef BSD_SIG
  vec.sv_handler = io_handler;
  vec.sv_mask = sigmask(SIGIO) |
    sigmask(SIGCHLD) |
      sigmask(SIGTSTP) |
        sigmask(SIGCONT);
  vec.sv_flags = 0;
  
  if (sigvec(SIGIO, &vec, (struct sigvec *)0) != 0)
    return ((rem_addr *)0);
#else
  if ((sigemptyset(&sigact.sa_mask) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGCHLD) != 0) || /* Block SIGCHLD to avoid
                                                      races */
      (sigaddset(&sigact.sa_mask,SIGIO) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGTSTP) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGCONT) != 0))
    return ((rem_addr *)0);
  
  sigact.sa_handler = io_handler;
  sigact.sa_flags = 0;

  if(sigaction(SIGIO, &sigact, (struct sigaction *)0) != 0)
    return((rem_addr *)0);
#endif

  /*
   * Initialization of communication Parameters 
   */

  if( gethostname(hostname, MAXHNAMELEN) < 0 ) 
    return ((rem_addr *)0);

  if ((hp = gethostbyname(hostname)) == (struct hostent *)0) 
    return((rem_addr *)0);

  memset((void *) &my_rem_addr.sad, (int)0, sizeof(struct sockaddr_in));
  memcpy((void *)&my_rem_addr.sad.sin_addr,
         (void *)hp->h_addr,
         (size_t)hp->h_length);

  if ((my_rem_addr.sockfd = _tcp_socket(&my_rem_addr.sad)) < 0)
    return ((rem_addr *)0);

  my_rem_addr.stat = ADDR_SET;
  
  /* handler einh"angen!!! */
  rem_handler = handler;

  return (&my_rem_addr);
}


