/******************************************************************************
*
*    Send a message to a remote process
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  remote_send.c,v
  1994/04/25 07:41:50
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts, Stephan Plogsie"s

  Description: Send a message to a remote process

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "remote_send.c,v 1.6 1994/04/25 07:41:50 lamberts Exp";
#endif


#include "../include/sys/nxlib.h"


extern int _tcp_send();


int _rem_send
#ifdef ANSI
(int fd, msg_desc *msgd)
#else
(fd, msgd)
int fd;
msg_desc    *msgd;
#endif
{
  /*
   * place for data conversion
   * attention for later versions!!
   * In a heterogenous network it is possible that the structure msg_desc
   * must be converted befor it can be transmitted.
   */

  if (_tcp_send(fd, (void *)msgd, (long)sizeof(msg_desc)) < 0)
    return(-1);

  if(msgd->msg_len > 0)
    if (_tcp_send(fd, (void *)msgd->msg_ptr, msgd->msg_len) < 0)
      return(-1);

  return(0);
}

