/******************************************************************************
*
*    Receive messages from remote
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  remote_recv.c,v
  1994/04/28 13:37:26
  1.8
  Exp
  plogstie
 
  Authors: Stephan Plogstie"s, Stefan Lamberts

  Description:

  This file contains the procedure _rem_recv(), which receives a single message
  reliably from a remote located node.

  Available functions from this module:
  
  _rem_recv(fd,msg)
  int fd;
  msg_desc *msg;

******************************************************************************/
#ifndef lint
static char rcs_id[] = "remote_recv.c,v 1.8 1994/04/28 13:37:26 plogstie Exp";
#endif

#include <stdlib.h>

#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern int _tcp_recv();


int _rem_recv
#ifdef ANSI
(int fd, msg_desc **msg)
#else
(fd, msg)
int  fd;
msg_desc **msg;
#endif
{

  /***
   *** Receive header
   ***/

  if ((*msg = (msg_desc *)malloc(sizeof(msg_desc))) == (msg_desc *)0)
    return(-1);

  (*msg)->msg_ptr = (char *)0;

  if (_tcp_recv(fd, (void *)*msg, (long)sizeof(msg_desc)) < 0)
    return (-1);

  if ((*msg)->msg_len > 0) 
  {
    if (((*msg)->msg_ptr
         = (char *)malloc((size_t)(sizeof(char)*(*msg)->msg_len)))
        == (char *)0)
      return (-1);

    if (_tcp_recv(fd, (void *)(*msg)->msg_ptr, (*msg)->msg_len) < 0)
      return (-1);
  }
  return (0);
}
