/******************************************************************************
*
*    Functions to handle the closing of a connection
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  remote_close.c,v
  1994/12/30 16:34:05
  1.4
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Functions to handle the closing of a connection

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "remote_close.c,v 1.4 1994/12/30 16:34:05 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>
#include <unistd.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __myhost();
extern int       _del_plistel_radr();
extern p_listel *_find_plistel_radr();
extern int       _inval_plistel_radr();


/*****************************************************************************/
int _rem_close
#ifdef ANSI
(rem_addr *radr)
#else
(radr)
rem_addr *radr;
#endif
/*****************************************************************************/
{
  p_listel *pe;
  
  if ((pe = _find_plistel_radr(radr)) == (p_listel *)0)
  {
    if (errno != 0)
      return (-1);
    
    /* There is no process to this socket. There must be another connection
     * to this process and this socket was closed by the other process.
     * Keep this socket open until a message is received that allows to close
     * the socket. */
    return (0);
  }
  
  /* If a daemon process or the controlling process terminated exit */

  if ((pe->ptypes.ptype == DAEMON_PTYPE) ||
      (pe->node == __myhost()))
    exit(0);

  /* Remove the socket descriptor form the address database */

  if (_inval_plistel_radr(radr) < 0)
    return -1;

  close(radr->sockfd);
  return (0);
}
