/******************************************************************************
*
*    En/Disable incomming messages
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  rel_enable.c,v
  1995/02/06 16:08:41
  1.7
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: En/Disable incomming messages

  Available functions from this module: ...

******************************************************************************/
#ifndef lint
static char rcs_id[] = "rel_enable.c,v 1.7 1995/02/06 16:08:41 lamberts Exp";
#endif

#include <signal.h>

extern void nx_perror();


static int disable_count = 0;
static int in_signal_handler = 0;

#ifdef BSD_SIG
static int oldmask;
#endif

/*****************************************************************************/
void _enter_signal_handler
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  in_signal_handler = 1;
}


/*****************************************************************************/
void _leave_signal_handler
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  in_signal_handler = 0;
}


/*****************************************************************************/
void _rel_disable
#ifdef ANSI
(void);
#else
()
#endif
/*****************************************************************************/
{
#ifndef BSD_SIG
  sigset_t set;
#endif
  
  if (in_signal_handler)
    return;

  if (disable_count == 0)
  {
#ifdef BSD_SIG
    oldmask = sigblock(sigmask(SIGIO) |
                       sigmask(SIGCHLD) |
                       sigmask(SIGTSTP) |
                       sigmask(SIGCONT));
#else
    sigemptyset(&set);
    sigaddset(&set,SIGIO);
    sigaddset(&set,SIGCHLD);
    sigaddset(&set,SIGTSTP);
    sigaddset(&set,SIGCONT);
    sigprocmask(SIG_BLOCK,&set,(sigset_t *)0);
#endif
  }

  disable_count++;

#ifdef REL_DISABLE_DEBUG
  _dbgmsg("_rel_disable() call %d",disable_count);
#endif
    
  return;
}



void _rel_enable
#ifdef ANSI
(void);
#else
()
#endif
{
#ifndef BSD_SIG
  sigset_t set;
#endif

  if (in_signal_handler)
    return;

  if (disable_count == 0)
  {
    nx_perror("WARNING: _rel_enable(): no matching _rel_disable()");
    return;
  }

#ifdef REL_DISABLE_DEBUG
  _dbgmsg("_rel_enable() call %d",disable_count);
#endif

  disable_count--;              /* Decrement while signals are blocked. */
  
  if (disable_count == 0)
  {
#ifdef BSD_SIG
    sigsetmask(oldmask);
#else
    sigemptyset(&set);
    sigaddset(&set,SIGIO);
    sigaddset(&set,SIGCHLD);
    sigaddset(&set,SIGTSTP);
    sigaddset(&set,SIGCONT);
    sigprocmask(SIG_UNBLOCK,&set,(sigset_t *)0);
#endif
  }

  return;
}

  
