/******************************************************************************
*
*    Handler for incomming messgages for daemon processes
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  d_handler.c,v
  1994/12/30 16:33:57
  1.9
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Handler for incomming messgages for daemon processes

  Available functions from this module:

******************************************************************************/
#ifndef lint
static char rcs_id[] = "d_handler.c,v 1.9 1994/12/30 16:33:57 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern int _ad_addappl();
extern int _ad_gfunct();
extern int _ad_loadappl();
extern int _ad_setptype();
extern int _addr_req();
extern int _cd_gfunct();
extern int _cd_initd();
extern int _cd_signal();
extern int _d_flushmsg();
#ifdef XPARAGON
extern int _d_xp_prot();
#endif
extern int _dd_addr_repl();
extern int _dd_apexit();
extern int _dd_pidnr();

/**************************************************************************
***************************************************************************/
int _d_handler
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/**************************************************************************/
{
  int res;
  
  if (msgd == (msg_desc *)0)
  {
    errno = EINVAL;
    return(-1);
  }
  

  switch (msgd->msg_type)
  {
  case CD_INITD:                /* CP->DP Address info of all daemons */
    res = _cd_initd(msgd);
    break;
  
  case AD_LOADAPPL:             /* AP->DP Load application process */  
    res = _ad_loadappl(msgd);
    break;
  
  case DA_PIDNR:                /* DP->AP reply to a nx_load (forwarded) */
    res = _dd_pidnr(msgd);
    break;

  case DA_APEXIT:               /* DP->AP exit message (forwarded) */
    res = _dd_apexit(msgd);
    break;

  case CD_SIGNAL:               /* CP->DP Signal to be forwarded */
    res = _cd_signal(msgd);
    break;
  
  case AD_ADDAPPL:              /* AP->DP Info from a loaded process */
    res = _ad_addappl(msgd);
    break;
  
  case AD_SETPTYPE:             /* AP->DP Set ptype request */
    res = _ad_setptype(msgd);
    break;
  
  case ADDR_REQ:                /* (AP/DP)->DP Address request */
    res = _addr_req(msgd);
    break;
  
  case ADDR_REPL:               /* DP->DP Address answer */
    res = _dd_addr_repl(msgd);
    break;
  
  case AD_GFUNCT:               /* AP->DP global function call */
    res = _ad_gfunct(msgd);
    break;
  
  case CD_GFUNCT:               /* CP->DP global function data */
    res = _cd_gfunct(msgd);
    break;
  
  case FLUSHMSG:
    res = _d_flushmsg(msgd);
    break;

  case XP_PROT:                 /* XPARAGON protocol message */
#ifdef XPARAGON
    res = _d_xp_prot(msgd);
#endif
    break;
  
  default:
    
    errno =  EBADMSG;
    res = -1;
    break;
  }
  
  if (msgd->msg_len != 0)
    free((void *)msgd->msg_ptr);
  free((void *)0);

  return (res);
}

