%{
/******************************************************************************
*
*    Syntactic analyser for partition files
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  read_part_y.y,v
  1994/05/02 13:05:33
  1.6
  Exp
  lamberts
 
  Authors: Susanna Schink, Stefan Lamberts

  Description:

  This file contains the parser to read from the specified partition file

  Available functions from this module:

  int _read_part(partition)
  char *partition;

******************************************************************************/

#ifndef lint
  static char rcs_id[] = "read_part_y.y,v 1.6 1994/05/02 13:05:33 lamberts Exp";
#endif
  
  
  
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"
  
extern FILE *yyin;
extern char  yytext[];
  
static int vpncount;
static vpn_spec *vpnspecs;
static vpn_spec *vpn;

int lineno;
  
%}

%union{
  char *str;
  vpn_spec *ptr;
  int  num;
}


%token NL ERRTOKEN ARCSYMB PATHSEP
  
%token <str> STRING
 
%token <num> NUMBER
  
%start VPNSpec
 
%%
  
VPNSpec: InitParser VPNList
  ;

InitParser:
             {
               lineno = 1;
               vpncount = 0;
               vpnspecs = (vpn_spec *)0;
             }
;

VPNList:   /*empty*/
         | Newlines VPN Newlines VPNList
         ;

VPN:       {
             if ((vpn = newvpn()) == (vpn_spec *)0)
               YYERROR;
           }
           NodeNumber WSAddrPath WSLogin WSArch NL
           {
             if (addvpn(vpn) < 0)
               YYERROR;
             vpncount++;
           }
     ;

NodeNumber:   NUMBER
              {
                vpn->node = $1;
              }
            ;

WSAddrPath:   WSAddress
              {
                strcpy(vpn->path,".");
              }

            | WSAddress PATHSEP WSPath
            ;


WSAddress:   STRING
             {
               if (strlen($1) >= MAXHNAMELEN)
               {
                 yyerror("hostname to long");
                 YYERROR;
               }
               strcpy(vpn->hname,$1);
             }
           ;  


WSPath:  STRING
         {
           if ($1[0] == '$')
           {
             char *str;
             if ((str = getenv(&$1[1])) == (char *)0)
             {
               yyerror("Environment variable is not set");
               YYERROR;
             }
             else if (strlen(str) >= MAXPATHLEN)
             {
               yyerror("pathname to long");
               YYERROR;
             }
             else
               strcpy(vpn->path,str);
           }
           else
           {
             if (strlen($1) >= MAXPATHLEN)
             {
               yyerror("pathname to long");
               YYERROR;
             }
             strcpy(vpn->path,$1);
           }
         }
       ;

  
 
WSLogin:   /* empty */
           {
             vpn->login[0] = '\0';
           }
         | STRING
           {
             if (strlen($1) >= MAXLOGINLEN)
             {
               yyerror("login name to long");
               YYERROR;
             }
             strcpy(vpn->login,$1);
           }
         ;

WSArch:   /* empty */
          {
            vpn->arch[0] = '\0';
          }
        | ARCSYMB STRING
          {
            if (strlen($2) >= MAXARCHLEN)
            {
              yyerror("architecture specification to long");
              YYERROR;
            }
            strcpy(vpn->arch,$2);
          }
        ;

Newlines: /* empty */
          | NL Newlines
          ;

%%
  
  
/**************************************************************************
 * will be called in case of an error 
 *************************************************************************/
static void yyerror(msg)
char *msg;
/*************************************************************************/

{
  fprintf(stderr,"Error in the partition file at or near line %d: %s\n",lineno,msg);
}



/**************************************************************************
 * Create new list element if node number doesn't already exist
 *************************************************************************/
static vpn_spec *
newvpn()
/*************************************************************************/
{
  vpn_spec *ptr;
  
  if ((ptr = (vpn_spec *)malloc(sizeof(vpn_spec))) == (vpn_spec *)0)
  {
    yyerror("malloc() failed");
    return (ptr);
  }

  ptr->next = (vpn_spec *)0;
  
  return(ptr);
}


/**************************************************************************
 * Add created list element to the list (sorted list)
 *************************************************************************/
static int addvpn(a)
vpn_spec *a;
/*************************************************************************/
{

  vpn_spec *pp;
  vpn_spec *ap;
  

  for (pp = (vpn_spec *)0, ap = vpnspecs;
       (ap != (vpn_spec *)0) && (ap->node < a->node);
       pp = ap, ap = ap->next);

  if ((ap != (vpn_spec *)0) && (ap->node == a->node))
  {
    yyerror("Node number exists");
    return (-1);
  }

  a->next = ap;
  if (pp == (vpn_spec *)0)
    vpnspecs = a;
  else
    pp->next = a;

  return (0);
}

/**************************************************************************
 * reads the user data, what else :-)
 *************************************************************************/
int _read_part
#ifdef ANSI
(char *partition, vpn_spec **vpnspec)
#else
(partition, vpnspec)
char *partition;
vpn_spec **vpnspec;
#endif
/*************************************************************************/
{
#ifdef DEBUG
  vpn_spec *p;
#endif
  
  if ((yyin = fopen(partition, "r")) == NULL)
  {
    switch (errno)
    {
    case ENOENT:
      errno = EPINVALPART;
      break;
    case EACCES:
      errno = EPACCES;
      break;
    }
    return -1;      /* Can't open file */
  }
  
  if (yyparse())
  {
    fprintf(stderr,"Error in '%s'\n",partition);
    fclose(yyin);
    errno = EPALLOCERR;
    *vpnspec = (vpn_spec *)0;
    return -1; /* Error in parser */  
  }
  
  fclose(yyin);
  
#ifdef DEBUG
  for (p = vpnspecs; p != (vpn_spec *)0; p = p->next)
    fprintf(stderr, "Node: %d\tHost: %s\tPath: %s\tLogin: %s\tArchitecture: %s\n",
            p->node, p->hname, p->path, p->login, p->arch);
  fprintf(stderr, "\n");
#endif
  *vpnspec = vpnspecs;
  return vpncount; 
}



