%{
/******************************************************************************
*
*    Lexical analyser for partition files
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  read_part_l.l,v
  1994/03/30 14:07:19
  1.5
  Exp
  lamberts
 
  Authors: Susanna Schink, Stefan Lamberts

  Description:
  
  This file contains the lex specification of the partition file parser

  Available functions from this module: ....

******************************************************************************/

#ifndef lint
static char rcsid[] = "read_part_l.l,v 1.5 1994/03/30 14:07:19 lamberts Exp";
#endif

#include <stdio.h>
#include <stdlib.h>

#include "../include/sys/nxlib.h"

#include "read_part_y.h"

extern int lineno;

%}


%%

#.*$                {  /* Comment in input file */
                      ;
                    }

\n                  {  /* End of a line */ 
                      lineno++;
                      return(NL);
                    }

[ \t]*              { /* Spaces or tabs are seperators */
                      ;
                    }


[0-9]+              { /* A number not starting with 0 */
                      yylval.num = atoi(yytext);
                      return(NUMBER);
                    }


[$/_a-zA-Z0-9.-]+    {  /* A string */
                      yylval.str = yytext;
                      return(STRING);
                    }

\%                 { 
                      return(ARCSYMB);
                   }

:                  {
                      return(PATHSEP);
                   }

.                  {
                      return(ERRTOKEN);
                   }

