/******************************************************************************
*
*    Functions needed by the daemon to load programs
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nxload_d.c,v
  1995/02/13 15:03:13
  1.10
  Exp
  lamberts
 
  Authors: Stefan Lamberts, Susanna Schink

  Description:
  This file contains the procedures that are needed to handle a nxload[ve]()
  call and within the daemon processes.

  Available functions from this module:

  void _cd_loadappl(msg)
  msg_desc *msg;
  
******************************************************************************/
#ifndef lint
static char rcs_id[] = "nxload_d.c,v 1.10 1995/02/13 15:03:13 lamberts Exp";
#endif

#include <sys/wait.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

#define NO_ARG 7

extern long      __myhost();
extern long      __mynode();
extern long      __myptype();
extern long      __numnodes();
extern int       _calc_applproc_code();
extern void      _dbgmsg();
extern p_listel *_find_plistel();
extern p_listel *_find_plistel_pid();
extern int       _ins_plistel();
extern int       _inval_plistel_pid();
extern void      _rel_disable();
extern void      _rel_enable();
extern int       _rel_send();
extern int       _set_addr_plistel();
extern char     *ltoa();
extern void      nx_perror();

extern int __tcpbufsize;

extern char **environ;


/*************************************************************************
  fork() and execve() an application process
**************************************************************************/    
static pid_t
#ifdef ANSI
forkexec(msg_desc *msgd)
#else
forkexec(msgd)
msg_desc *msgd;
#endif
/************************************************************************/
{
  pid_t   childpid;
  int     argc;
  int     envc;
  int     i;

  long    ptype;

  char    *path;
  char    *msg_rest;
  char    **argv;
  char    **envp;
  p_listel *pe;

  msg_ad_loadappl  *msg_part;


  msg_part = (msg_ad_loadappl *)msgd->msg_ptr;
  ptype = msg_part->ptype;
  argc = msg_part->argc;
  envc = msg_part->envc;
  
  /* 
   * Is the ptype already in use ? If yes, don't start the process;
   * otherwise put this new ptype in the hash table
   */

  if (_find_plistel(__mynode(),ptype) != (p_listel *)0)  
    return (0);
  
  if ((pe = _find_plistel(__mynode(),(long)DAEMON_PTYPE)) == (p_listel *)0)
    return (0);
  
  /* ptype not in use */
  if ((childpid = fork()) == (pid_t)-1) 
    return (0);
  else if (childpid == (pid_t)0)
  {                              /* child process */
#ifdef HALTLOAD
    int dbg = 1;
    while (dbg);
#endif
    
    msg_rest = ((char *)msgd->msg_ptr) + sizeof(msg_ad_loadappl);

    /* restore path */
    path = msg_rest;
    msg_rest += (strlen(path) + 1);

    /* allocate memory for the argument vector
     * 8 extra arguments are necessary in order to specify
     *   - argv[1] : code to idetnitfy an application process
     *   - argv[2] : the portnumber of the daemon
     *   - argv[3] : the number of nodes in that application
     *   - argv[4] : the nodenumber of this node
     *   - argv[5] : the ptype of that process
     *   - argv[6] : TCP buffer size
     *   - argv[7] : a copy of argv[0] in order to restore the argv easier
     *   - a terminamting pointer (char *)0
     */
    if (((argv = (char **)malloc((size_t)(sizeof(char **)*(argc+NO_ARG+1))))
        == (char **)0) ||
        ((argv[2] = ltoa((long)pe->radr.sad.sin_port)) == (char *)0) ||
        ((argv[3] = ltoa(__numnodes())) == (char *)0) ||
        ((argv[4] = ltoa(__mynode())) == (char *)0) ||
        ((argv[5] = ltoa(ptype)) == (char *)0) ||
        ((argv[6] = ltoa((long)__tcpbufsize)) == (char *)0))
    {
      nx_perror("nx_loadve(): child");
      exit(-1);
    }
    
    /* restore arguments */
    if (argc > 0) 
    {
      argv[0] = msg_rest;
      argv[NO_ARG] = msg_rest;
      msg_rest += (strlen(argv[0])+1);
    }
    else 
    {                              /* at least argv[0] must be specified */
      errno = 0;
      nx_perror("There must be at least one argument");
      exit(-1);
    }
    
    for (i = 1; i < argc; i++) 
    {
      argv[i+NO_ARG] = msg_rest;
      msg_rest += (strlen(argv[i+NO_ARG]) + 1) ;
    }

    argv[i+NO_ARG] = (char *)0;
  
    /* Calculate the code that specifies an application process */
    if (((argv[1]=ltoa((long)_calc_applproc_code(argv))) == (char *)0) ||
        ((envp = (char **)malloc((size_t)(sizeof(char **)*(envc+1))))
         == (char **)0))
    {
      nx_perror("nx_loadve(): child");
      exit(-1);
    }
  
    /* restore environment */
    for (i = 0; i < envc; i++) 
    {
      envp[i] = msg_rest;
      msg_rest += (strlen(envp[i]) + 1) ;
    }
    
    envp[i] = (char *)0;

    environ = envp;              /* set the specified environment */
    execvp(path,argv);

    /* theese statements will be reached only in case of an error */
    nx_perror("nx_loadve(): child");
    _dbgmsg("Could not execute %s",path);
    exit(-1);
  } /* End of child process */
  
  /* daemon process */

  /* insert chid in address database */
  if (_ins_plistel(__mynode(),
                   ptype,
                   LOC_REMOTE,
                   (rem_addr *)0,
                   (loc_addr *)0,
                   pe->hname,
                   pe->login,
                   pe->arch,
                   childpid,
                   msg_part->l_node,
                   msg_part->l_ptype) < 0)

    return (0);

  return (childpid);
}

/****************************************************************************
  call the procedure forkexec() and send the appropiate message back to the
  caller of nxload[ve]()
****************************************************************************/

int
#ifdef ANSI
_ad_loadappl(msg_desc *msgd);
#else
_ad_loadappl(msgd)
msg_desc *msgd;
#endif
{
  msg_ad_loadappl  *msg_part;
  
  msg_da_pidnr pid_msg;

  msg_part = (msg_ad_loadappl *)msgd->msg_ptr;
  
  if (msg_part->node != __mynode())
  {
    /* Forward the message to the approprite daemon */
    if (_rel_send((long)AD_LOADAPPL,
                  msgd->msg_ptr,
                  msgd->msg_len,
                  msg_part->node,
                  (long)DAEMON_PTYPE) < 0)
      return (-1);
    return (0);
  }
  
  /* Fork and exec the application process */
  pid_msg.l_node = msg_part->l_node;
  pid_msg.l_ptype = msg_part->l_ptype;
  pid_msg.pid = forkexec(msgd);
  pid_msg.naidx = msg_part->naidx;
  
  if (_rel_send((long)DA_PIDNR,
                (char *)&pid_msg,
                (long)sizeof(msg_da_pidnr),
                msg_part->l_node,
                /* If the loading process is the controlling process
                   send the answer directly, otherwise to the daemon which will
                   forward it */
                ( (msg_part->l_node == __myhost()) || 
                  (msg_part->l_node == __mynode()) )
                ? msg_part->l_ptype
                : (long)DAEMON_PTYPE) < 0)
    return (-1);

  return (0);
  
}





/*****************************************************************************/
int _ad_addappl
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  
  msg_ad_addappl *msg;
  
  msg = (msg_ad_addappl *)msgd->msg_ptr;

  if (_set_addr_plistel(msg->node,
                        msg->ptype,
                        LOC_UNDEF,
                        &msg->radr,
                        (loc_addr *)0,
                        (char *)0,
                        (char *)0,
                        (char *)0,
                        UNDEF_PID) < 0)
    return (-1);
  
  return (0);
}






/*************************************************************************
 * signal handler for the daemon process, which is not interested in it's
 * childs exit status, but needs to wait for them, to avoid clogging up the
 * system with zombies
 ************************************************************************/
void _ap_sig_child
#ifdef ANSI
(void)
#else
()
#endif
/*************************************************************************/
{
  pid_t pid;
  int status;
  p_listel *pe;
  int loc_errno = errno;
  
  msg_da_apexit amsg;

  /* Get exit status of all children.
   * The while loop is neccessary because a SIGCHLD might be lost.
   */
  while ((pid = waitpid(-1,&status,WNOHANG|WUNTRACED)) != 0) 
  {
    if ((pid < 0) && (errno == ECHILD))
      break;
    
    if (pid < 0)
    {
      nx_perror("_ap_sig_child() 1");
      exit(-1);
    }
  
    if (WIFSIGNALED(status) || WIFEXITED(status))
    {
      if ((pe = _find_plistel_pid(__mynode(),pid)) == (p_listel *)0)
      {
        nx_perror("_ap_sig_child() 2");
        exit(-1);
      }
      
      /* Inform the process that loaded  the terminated process */
      amsg.l_node = pe->l_node;
      amsg.l_ptype = pe->l_ptype;
      amsg.node = pe->node;
      amsg.pid = pe->pid;
      amsg.status = status;

      if (_rel_send((long)DA_APEXIT,
                    (char *)&amsg,
                    (long)sizeof(msg_da_apexit),
                    pe->l_node,
                    /* If the loading process was the controlling process send
                       the answer directly, otherwise to the daemon which will
                       forward it */
                    ((pe->l_node == __myhost()) ||
		     (pe->l_node == __mynode()))
                    ? pe->l_ptype
                    : (long)DAEMON_PTYPE) < 0)
      {
        nx_perror("_ap_sig_child() 3");
        exit(-1);
      }
      if (_inval_plistel_pid(__mynode(),pid) < 0)
      {
        nx_perror("_ap_sig_child() 4");
        exit(-1);
      }
    }
  }
  
  errno = loc_errno;
  return;
}




/*****************************************************************************/
int _dd_apexit
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  msg_da_apexit *msg;

  msg = (msg_da_apexit *)msgd->msg_ptr;

  /* Forward the message to the appropriate daemon */
  if (_rel_send((long)DA_APEXIT,
                msgd->msg_ptr,
                msgd->msg_len,
                msg->l_node,
                msg->l_ptype) < 0)
    return (-1);

  return (0);
}

  

/*****************************************************************************/
int _dd_pidnr
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  msg_da_pidnr *msg;

  msg = (msg_da_pidnr *)msgd->msg_ptr;

  /* Forward the message to the appropriate daemon */
  if (_rel_send((long)DA_PIDNR,
                msgd->msg_ptr,
                msgd->msg_len,
                msg->l_node,
                msg->l_ptype) < 0)
    return (-1);

  return (0);
}

  
