/******************************************************************************
*
*    Print error messages for an errno.
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nxerror.c,v
  1994/08/17 14:43:12
  1.7
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Print error messages for an errno.

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "nxerror.c,v 1.7 1994/08/17 14:43:12 lamberts Exp";
#endif

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "../include/sys/nxlib.h"
#include "../include/sys/nxerrno.h"
#include "../include/nxmalloc.h"

extern long __mynode();
extern long __myptype();
extern char *ltoa();

static struct 
{
  int no;
  char *msg;
}  no_msg[] =
{
  /***
   *** PARAGON specific errors
   ***/

  /* Partition Management Error Codes */
  EPALLOCERR, "allocator internal error",                 /* (F_PMERR+0) */
  EPXRS, "exceeds partition resources",                   /* (F_PMERR+1) */
  EPBADNODE, "bad node specification",                    /* (F_PMERR+2) */
  EPINVALPART, "partition not found",                     /* (F_PMERR+3) */
  EPINVALPRI, "invalid priority",                         /* (F_PMERR+4) */
  EPNOTEMPTY, "partition not empty",                      /* (F_PMERR+5) */
  EPINVALMOD, "invalid mode",                             /* (F_PMERR+6) */
  EPPARTEXIST, "partition exists",                        /* (F_PMERR+7) */
  EPINVALSCHED, "invalid scheduling",                     /* (F_PMERR+8) */
  EPACCES, "partition permission denied",                 /* (F_PMERR+9) */
  ERFORK, "do a rfork instead of a fork",                 /* (F_PMERR+10) */
  EAINVALPKT, "packet size invalid or out of range",      /* (F_PMERR+20) */
  EAINVALMBF, "memory buffer invalid or out of range",    /* (F_PMERR+21) */
  EAINVALMEX, "memory export invalid or out of range",    /* (F_PMERR+22) */
  EAINVALMEA, "memory each invalid or out of range",      /* (F_PMERR+23) */
  EAINVALSTH, "send threshold invalid or out of range",   /* (F_PMERR+24) */
  EAINVALSCT, "send count invalid or out of range",       /* (F_PMERR+25) */
  EAINVALGTH, "give threshold invalid or out of range",   /* (F_PMERR+26) */
  EANOTPGL, "calling process not process group leader",   /* (F_PMERR+27) */
  EAEXIST, "application exists for process group",        /* (F_PMERR+28) */
  EPINUSER,  "Invalid User",                              /* (F_PMERR+29) */
  EPINGRP, "Invalid group",                               /* (F_PMERR+30) */
  EPINRN,  "Invalid partition rename",                    /* (F_PMERR+31) */
  EPLOCK,  "Partition lock denied",                       /* (F_PMERR+32) */
  EPBXRS,  "partition request contains bad/missing nodes", /* (F_PMERR+33) */
  EANOEXIST, "application does not exist for process group", /* (F_PMERR+34) */
  EINTERNAL, "Miscellaneous internal error",              /* (F_PMERR+35) */


  EQPBUF, "Invalid buffer pointer",                       /* (F_NXERR+0) */
  EQBLEN, "Buffer length exceeds allocation",             /* (F_NXERR+1) */
  EQLEN, "Invalid length",                                /* (F_NXERR+2) */
  EQTIME, "Time limit exceeded",                          /* (F_NXERR+3) */
  EQMSGLONG, "Received message too long for buffer",      /* (F_NXERR+4) */
  EQPID, "Invalid ptype",                                 /* (F_NXERR+5) */
  EQNODE, "Invalid node",                                 /* (F_NXERR+6) */
  EQTYPE, "Invalid type",                                 /* (F_NXERR+7) */
  EQMID, "Invalid message id",                            /* (F_NXERR+8) */
  EQHND, "Invalid handler type",                          /* (F_NXERR+9) */
  EQNOPROC, "Out of process slots",                       /* (F_NXERR+10) */
  EQUSEPID, "Ptype already in use",                       /* (F_NXERR+11) */
  EQNOACT, "No active process",                           /* (F_NXERR+12) */
  EQBADFIL, "Invalid object file",                        /* (F_NXERR+13) */
  EQPARAM, "Invalid parameter",                           /* (F_NXERR+14) */
  EQPFIL, "Invalid file name pointer",                    /* (F_NXERR+15) */
  EQPCNODE, "Invalid cnode pointer",                      /* (F_NXERR+16) */
  EQPCPID, "Invalid cpid pointer",                        /* (F_NXERR+17) */
  EQPCCODE, "Invalid ccode pointer",                      /* (F_NXERR+18) */
  EQPRIV, "Privileged operation",                         /* (F_NXERR+19) */
  EQMEM, "Not enough memory",                             /* (F_NXERR+20) */
  EQNOMID, "Too many requests",                           /* (F_NXERR+21) */
  EQSET, "Ptype already set",                             /* (F_NXERR+22) */
  EQNOSET, "No ptype defined",                            /* (F_NXERR+23) */
  EQUSM, "Invalid diagnostic channel usm id",             /* (F_NXERR+24) */
  EQDIM, "Invalid dimension",                             /* (F_NXERR+25) */
  EQMODE, "Invalid diagnostic channel mode",              /* (F_NXERR+26) */
  EQSTATUS, "Invalid diagnostic channel status",          /* (F_NXERR+27) */
  EQMSGSHORT, "Received message too short for buffer",    /* (F_NXERR+28) */
  ECFPS, "Seek to different file pointers",               /* (F_NXERR+29) */
  ENFPS, "Different file pointers",                       /* (F_NXERR+30) */
  EMIXIO, "Mixed file operations",                        /* (F_NXERR+31) */
  EIMODE, "Bad io mode number",                           /* (F_NXERR+32) */
  ESETIO, "File is not synchronized",                     /* (F_NXERR+33) */
  ENOCFS, "No CFS available",                             /* (F_NXERR+34) */
  EQESIZE, "Invalid size",                                /* (F_NXERR+35) */
  ERDEOF, "Attempt to read past end of file",             /* (F_NXERR+36) */
  EQPATH, "Path name too long",                           /* (F_NXERR+37) */
  EQTAM, "Max number of applications under debug was reached.", /* (F_NXERR+38) */
  EQPGRP, "Supplied processes group does not exist or is under control of another TAM.", /* (F_NXERR+39) */
  EFSNOTSUPP,    "Operation not supported by this file system.",  /* (F_NXERR+40) */
  ENXLADR, "Internal error in address database",          /* (F_NXLERR+0) */
  ENXLENEX, "Entry does not exist in address database",   /* (F_NXLERR+1) */
  ENXLEEX, "Entry does exist in address database",        /* (F_NXLERR+2) */
  ENXLBUF, "Internal error in buffer layer",              /* (F_NXLERR+3) */
  ENXLTCPBUF, "Invalid TPC buffer size",                  /* (F_NXLERR+4) */
  /* This entry must be last */
  -1, ""
};
  




void
#ifdef ANSI
nx_perror(char *str)
#else
nx_perror(str)
char *str;
#endif
{

  int i;
  long p;
  char *pt;
  
  switch ((p = __myptype()))
  {
  case CP_PTYPE:
    pt = "C";
    break;
  case DAEMON_PTYPE:
    pt = "D";
    break;
  default:
    if ((pt = ltoa(p)) == (char *)0)
      pt = "?";
    break;
  }

  for (i=0; no_msg[i].no != -1; i++)
    if (no_msg[i].no == errno)
    {
      fprintf(stderr,"(node %ld, ptype %s) %s: %s\n",
              __mynode(),pt,str,no_msg[i].msg);
      return;
    }
  
  fprintf(stderr,"(node %ld, ptype %s) ",
            __mynode(),pt);
  perror(str);

  if ((p != CP_PTYPE) && (p != DAEMON_PTYPE))
    free((void *)pt);
  return;

}


