/******************************************************************************
*
*    En/Disable interrupt driven communication
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  masktrap.c,v
  1994/04/29 08:37:27
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: En/Disable interrupt driven communication

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "masktrap.c,v 1.6 1994/04/29 08:37:27 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"

extern long __myptype();
extern void _rel_disable();
extern void _rel_enable();
extern int  _rel_isable();
extern long _set_trap_mask();
extern void nx_perror();


/*****************************************************************************/
long _masktrap
#ifdef ANSI
(long state);
#else
(state)
long state;
#endif
/*****************************************************************************/
{
  long res;

  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if ((state != 0) && (state != 1))
  {
    errno = EINVAL;
    return (-1);
  }

  _rel_disable();
  
  res = _set_trap_mask(state);

  _rel_enable();
    
  return (res);
}

    

/*****************************************************************************/
long masktrap
#ifdef ANSI
(long state);
#else
(state)
long state;
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _masktrap(state)) < 0)
  {
    nx_perror("masktrap()");
    exit (-1);
  }

  return (res);
}



