/******************************************************************************
*
*    Asynchronous send
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  isend.c,v
  1995/02/13 10:28:34
  1.4
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Asynchronous send

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "isend.c,v 1.4 1995/02/13 10:28:34 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __mynode();
extern long      __myptype();
extern long      __numnodes();
extern int       _buf_send();
extern buf_c_el *_create_call();
extern long      _dummy_msgid();
extern int       _get_addr();
extern int       _ins_call();
extern long      _ins_msgid();
extern long      _irecvx();
extern long      _msgmerge();
extern void      _rel_disable();
extern void      _rel_enable();
extern void      nx_perror();

extern long msginfo[];


/*****************************************************************************/
static long __isend
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype)
#else
(type, buf, count, node, ptype)
long type;
char *buf;
long count;
long node;
long ptype;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  long msg_id = -1;

  /* Disbale incomming messages to avoid races */
  _rel_disable();

  if ((bce =_create_call(ISEND,
                         type, buf, count,
                         node, ptype, __mynode(), __myptype(),
                         (void (*)())0, (long)0, (long *)0)) == (buf_c_el *) 0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }

  if (_ins_call(bce) < 0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }

  if ((msg_id = _ins_msgid(bce)) < 0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }
  
  switch (_get_addr(node, ptype))
  {
  case 1:
    /* address is known */
    if (_buf_send(__myptype(),node, ptype) < 0)
    {
      /* Enable incomming messages */
      _rel_enable();
    
      return (-1);
    }
    
    break;
  case 0:
    /* address is not known */
    break;
  default:
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }
  
  /* Enable incomming messages */
  _rel_enable();
    
  return (msg_id);
}

  
/*****************************************************************************/
long _isend
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype)
#else
(type, buf, count, node, ptype)
long type;
char *buf;
long count;
long node;
long ptype;
#endif
/*****************************************************************************/
{
  long msg_id;
  long n_msg_id;
  long i;
  
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if ((type < 0) || 
      ((type >= MAXUMT) && (type < MAXSMT)) ||
      (type >= MAXFMT)) 
  {
    errno = EQTYPE;
    return (-1);
  }
  
  if ((buf == (char *)0) && (count > 0))
  {
    errno = EQPBUF;
    return (-1);
  }
  
  if (count < 0)
  {
    errno = EAINVALSCT;
    return (-1);
  }

  if (((node != -1) && (node < 0)) ||
      (node > __numnodes()))
  {
    errno = EQNODE;
    return (-1);
  }

  if ((ptype < 0) || (ptype > MAXPTYPE))
  {
    errno = EQPID;
    return (-1);
  }

  if (node == -1)
  {
    msg_id = _dummy_msgid();
    
    for (i = 0; i < __numnodes(); i++)
    {
      if ((i != __mynode()) || (ptype != __myptype()))
      {
        if ((n_msg_id = __isend(type, buf, count, i, ptype)) < 0)
          return (-1);

        if ((msg_id = _msgmerge(msg_id,n_msg_id)) < 0)
          return (-1);
      }
    }
  }
  else if ((msg_id = __isend(type, buf, count, node, ptype)) < 0)
    return (-1);
          
  return (msg_id);
}

    
/*****************************************************************************/
long isend
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype)
#else
(type, buf, count, node, ptype)
long type;
char *buf;
long count;
long node;
long ptype;
#endif
/*****************************************************************************/
{
  long res;
  
  if ((res = _isend(type, buf, count, node, ptype)) < 0)
  {
    nx_perror("isend()");
    exit(-1);
  }

  return (res);
}



/*****************************************************************************/
long _isendrecv
#ifdef ANSI
(long type, char *sbuf, long scount, long node, long ptype,
 long typesel, char *rbuf, long rcount)
#else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount)
long type;
char *sbuf;
long scount;
long node;
long ptype;
long typesel;
char *rbuf;
long rcount;
#endif
/*****************************************************************************/
{
  long smsg_id;
  long rmsg_id;

  if ((smsg_id = _isend(type, sbuf, scount, node, ptype)) < 0)
    return (-1);

  if ((rmsg_id = _irecvx(typesel, rbuf, rcount, node, ptype, msginfo)) < 0)
    return (-1);

  return (_msgmerge(smsg_id, rmsg_id));
}


/*****************************************************************************/
long isendrecv
#ifdef ANSI
(long type, char *sbuf, long scount, long node, long ptype,
 long typesel, char *rbuf, long rcount)
#else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount)
long type;
char *sbuf;
long scount;
long node;
long ptype;
long typesel;
char *rbuf;
long rcount;
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _isendrecv(type, sbuf, scount, node, ptype,
                        typesel, rbuf, rcount)) < 0)
  {
    nx_perror("isendrecv()");
    exit(-1);
  }

  return (res);
}

  
