/******************************************************************************
*
*    Asynchronous receive
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  irecv.c,v
  1995/02/13 10:28:32
  1.7
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Asynchronous receive

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "irecv.c,v 1.7 1995/02/13 10:28:32 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>
#include <string.h>

#ifdef SUN_OS4
#include <memory.h>             /* Should be included in string.h */
#endif

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __mynode();
extern long      __myptype();
extern long      __numnodes();
extern buf_c_el *_create_call();
extern int       _del_msg();
extern buf_m_el *_find_msg();
extern int       _ins_call();
extern long      _ins_msgid();
extern void      _rel_disable();
extern void      _rel_enable();
extern int       _rm_msg();
extern void      nx_perror();

extern long msginfo[];


/*****************************************************************************/
long _irecvx
#ifdef ANSI
(long typesel, char *buf, long count, long nodesel, long ptypesel, long *info)
#else
(typesel, buf, count, nodesel, ptypesel, info)
long typesel;
char *buf;
long count;
long nodesel;
long ptypesel;
long *info;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  buf_m_el *bme;
  long msg_id;

  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if (((typesel != -1) && (typesel < 0)) || 
      ((typesel >= MAXUMT) && (typesel < MAXSMT)) ||
      (typesel >= MAXFMT)) 
  {
    errno = EQTYPE;
    return (-1);
  }
  
  if ((buf == (char *)0) && (count > 0))
  {
    errno = EQPBUF;
    return (-1);
  }
  
  if (count < 0)
  {
    errno = EAINVALSCT;
    return (-1);
  }

  if (((nodesel != -1) && (nodesel < 0)) ||
      (nodesel > __numnodes()))
  {
    errno = EQNODE;
    return (-1);
  }

  if (((ptypesel != -1) && (ptypesel < 0)) ||
      (ptypesel > MAXPTYPE))
  {
    errno = EQPID;
    return (-1);
  }

  if (info == (long *)0)
  {
    errno = EQPARAM;
    return (-1);
  }

  /* Disable incomming messages to avoid races */
  _rel_disable();
  
  if ((bce = _create_call(IRECVX,
                          typesel, buf, count,
                          __mynode(), __myptype(), nodesel, ptypesel,
                          (void (*)())0,(long)0,info)) == (buf_c_el *)0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }

  if (_ins_call(bce) < 0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }

  if ((msg_id = _ins_msgid(bce)) < 0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }

  /* Check allready received messages */
  if ((bme = _find_msg(typesel, nodesel, ptypesel)) != (buf_m_el *)0)
  {
    /* There is a message */
    
    bce->status = CALL_DONE;    /* The call must be CALL_DONE
                                   because either myptype() was right
                                   when the message arrived (so it was
                                   confirmed) or a setptype() call was
                                   done before this _irecvx() call (so
                                   the message was confirmed in the
                                   setptype() call */

    /* Copy message */
    bce->msg_type = bme->msg_type;
    bce->s_node = bme->s_node;
    bce->s_ptype = bme->s_ptype;
    if (bce->count > bme->msg_len)
    {
      bce->errno = EQMSGSHORT;
      if (bme->msg_len > 0)
        memcpy((void *)bce->buf,(void *)bme->msg_ptr,(size_t)bme->msg_len);
    }
    else if (bce->count < bme->msg_len)
    {
      bce->errno = EQMSGLONG;
      if (bce->count > 0)
        memcpy((void *)bce->buf,(void *)bme->msg_ptr,(size_t)bce->count);
    }
    else if (bme->msg_len > 0)
      memcpy((void *)bce->buf,(void *)bme->msg_ptr,(size_t)bme->msg_len);
    
    bce->msg_len = bme->msg_len;
  
    /* Remove and delete message for message buffer */
    if (_rm_msg(bme) < 0)
    {
      /* Enable incomming messages */
      _rel_enable();
    
      return (-1);
    }
    
    if (_del_msg(bme) < 0)
    {
      /* Enable incomming messages */
      _rel_enable();
  
      return (-1);
    }
    
  }

  /* Enable incomming messages */
  _rel_enable();
    
  return (msg_id);
}




/*****************************************************************************/
long irecvx
#ifdef ANSI
(long typesel, char *buf, long count, long nodesel, long ptypesel, long *info)
#else
(typesel, buf, count, nodesel, ptypesel, info)
long typesel;
char *buf;
long count;
long nodesel;
long ptypesel;
long *info;
#endif
/*****************************************************************************/
{
  long msg_id;

  if ((msg_id = _irecvx(typesel, buf, count, nodesel, ptypesel, info)) < 0)
  {
    nx_perror("irecvx()");
    exit(-1);
  }
  
  return (msg_id);
}



/*****************************************************************************/
long _irecv
#ifdef ANSI
(long typesel, char *buf, long count)
#else
(typesel, buf, count)
long typesel;
char *buf;
long count;
#endif
/*****************************************************************************/
{
  return (_irecvx(typesel, buf, count, (long)-1, (long)-1, msginfo));
}



/*****************************************************************************/
long irecv
#ifdef ANSI
(long typesel, char *buf, long count)
#else
(typesel, buf, count)
long typesel;
char *buf;
long count;
#endif
/*****************************************************************************/
{
  long msg_id;

  if ((msg_id = _irecv(typesel, buf, count)) < 0)
  {
    nx_perror("irecv()");
    exit(-1);
  }
  
  return (msg_id);
}


