/******************************************************************************
*
*    info...() calls
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  info.c,v
  1994/01/19 10:57:56
  1.3
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: info...() calls

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "info.c,v 1.3 1994/01/19 10:57:56 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"

extern long __myptype();
extern void nx_perror();

long msginfo[8] = {0, 0, 0, 0, 0, 0, 0, 0};


/*****************************************************************************/
long _infocount
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  return (msginfo[1]);
}



/*****************************************************************************/
long infocount
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _infocount()) < 0)
  {
    nx_perror("infocount()");
    exit(-1);
  }

  return (res);
}


/*****************************************************************************/
long _infonode
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  return (msginfo[2]);
}



/*****************************************************************************/
long infonode
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _infonode()) < 0)
  {
    nx_perror("infonode()");
    exit(-1);
  }

  return (res);
}


/*****************************************************************************/
long _infoptype
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  return (msginfo[3]);
}



/*****************************************************************************/
long infoptype
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _infoptype()) < 0)
  {
    nx_perror("infoptype()");
    exit(-1);
  }

  return (res);
}


/*****************************************************************************/
long _infotype
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  return (msginfo[0]);
}



/*****************************************************************************/
long infotype
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _infotype()) < 0)
  {
    nx_perror("infotype()");
    exit(-1);
  }

  return (res);
}

