/******************************************************************************
*
*    Interrupt driven send
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  hsend.c,v
  1995/02/13 10:28:30
  1.4
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Interrupt driven send

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "hsend.c,v 1.4 1995/02/13 10:28:30 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __mynode();
extern long      __myptype();
extern long      __numnodes();
extern int       _buf_send();
extern buf_c_el *_create_call();
extern int       _get_addr();
extern long      _hrecvx();
extern int       _ins_call();
extern long      _isend();
extern long      _msgignore();
extern void      _rel_disable();
extern void      _rel_enable();
extern void      nx_perror();




/*****************************************************************************/
static long __hsendx
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype,
 void (*xhandler)(), long hparam)
#else
(type, buf, count, node, ptype, xhandler, hparam)
long type;
char *buf;
long count;
long node;
long ptype;
void (*xhandler)();
long hparam;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  
  /* Disable incomming messages to avoid races */
  _rel_disable();

  if ((bce =_create_call(HSENDX,
                         type, buf, count,
                         node, ptype, __mynode(), __myptype(),
                         xhandler, hparam, (long *)0)) == (buf_c_el *) 0)
  {
    /* Enable incomming messages */
    _rel_enable();

    return (-1);
  }
  
  if (_ins_call(bce) < 0)
  {
    /* Enable incomming messages */
    _rel_enable();

    return (-1);
  }

  switch (_get_addr(node, ptype))
  {
  case 1:
    /* address is known */
    if (_buf_send(__myptype(),node, ptype) < 0)
    {
      /* Enable incomming messages */
      _rel_enable();

      return (-1);
    }
    
    break;
  case 0:
    /* address is not known */
    break;
  default:
    /* Enable incomming messages */
    _rel_enable();

    return (-1);
  }

  /* Enable incomming messages */
  _rel_enable();

  return (0);
}

/*****************************************************************************/
long _hsendx
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype,
 void (*xhandler)(), long hparam)
#else
(type, buf, count, node, ptype, xhandler, hparam)
long type;
char *buf;
long count;
long node;
long ptype;
void (*xhandler)();
long hparam;
#endif
/*****************************************************************************/
{
  long i;
  
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if ((type < 0) || 
      ((type >= MAXUMT) && (type < MAXSMT)) ||
      (type >= MAXFMT)) 
  {
    errno = EQTYPE;
    return (-1);
  }
  
  if ((buf == (char *)0) && (count > 0))
  {
    errno = EQPBUF;
    return (-1);
  }
  
  if (count < 0)
  {
    errno = EAINVALSCT;
    return (-1);
  }

  if (((node != -1) && (node < 0)) ||
      (node > __numnodes()))
  {
    errno = EQNODE;
    return (-1);
  }

  if ((ptype < 0) || (ptype > MAXPTYPE))
  {
    errno = EQPID;
    return (-1);
  }

  if (xhandler == (void (*)())0)
  {
    errno = EQHND;
    return (-1);
  }

  if (node == -1)
  {
    for (i = 0; i < __numnodes(); i++)
    {
      if ((i != __mynode()) || (ptype != __myptype()))
      {
        if (__hsendx(type, buf, count, i, ptype, xhandler, hparam) < 0)
          return (-1);
      }
    }
  }
  else if (__hsendx(type, buf, count, node, ptype, xhandler, hparam) < 0)
    return (-1);
          
  return (0);
}

    
/*****************************************************************************/
void hsendx
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype,
 void (*xhandler)(), long hparam)
#else
(type, buf, count, node, ptype, xhandler, hparam)
long type;
char *buf;
long count;
long node;
long ptype;
void (*xhandler)();
long hparam;
#endif
/*****************************************************************************/
{
  if (_hsendx(type, buf, count, node, ptype, xhandler, hparam) < 0)
  {
    nx_perror("hsendx()");
    exit(-1);
  }

  return;
}

    
/*****************************************************************************/
long _hsend
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype, void (*handler)())
#else
(type, buf, count, node, ptype, handler)
long type;
char *buf;
long count;
long node;
long ptype;
void (*handler)();
#endif
/*****************************************************************************/
{
  return (_hsendx(type, buf, count, node, ptype, handler, (long)0));
}

    
/*****************************************************************************/
void hsend
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype, void (*handler)())
#else
(type, buf, count, node, ptype, handler)
long type;
char *buf;
long count;
long node;
long ptype;
void (*handler)();
#endif
/*****************************************************************************/
{
  if (_hsend(type, buf, count, node, ptype, handler) < 0)
  {
    nx_perror("hsend()");
    exit(-1);
  }

  return;
}



/*****************************************************************************/
long _hsendrecv
#ifdef ANSI
(long type, char *sbuf, long scount, long node, long ptype,
 long typesel, char *rbuf, long rcount, void (*handler)())
#else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount, handler)
long type;
char *sbuf;
long scount;
long node;
long ptype;
long typesel;
char *rbuf;
long rcount;
void (*handler)();
#endif
/*****************************************************************************/
{
  long msg_id;

  if ((msg_id = _isend(type, sbuf, scount, node, ptype)) < 0)
    return (-1);

  if (_msgignore(msg_id) < 0)
    return (-1);

  if (_hrecvx(typesel, rbuf, rcount, node, ptype, handler, (long)0) < 0)
    return (-1);

  return (0);
}


/*****************************************************************************/
void hsendrecv
#ifdef ANSI
(long type, char *sbuf, long scount, long node, long ptype,
 long typesel, char *rbuf, long rcount, void (*handler)())
#else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount, handler)
long type;
char *sbuf;
long scount;
long node;
long ptype;
long typesel;
char *rbuf;
long rcount;
void (*handler)();
#endif
/*****************************************************************************/
{
  if (_hsendrecv(type, sbuf, scount, node, ptype,
                 typesel, rbuf, rcount, handler))
  {
    nx_perror("hsendrecv()");
    exit(-1);
  }

  return;
}

  
