/******************************************************************************
*
*    Interrupt driven receive
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  hrecv.c,v
  1995/02/13 10:28:28
  1.7
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Interrupt driven receive

  Available functions from this module: .....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "hrecv.c,v 1.7 1995/02/13 10:28:28 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>
#include <string.h>

#ifdef SUN_OS4
#include <memory.h>             /* Should be included in string.h */
#endif

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __mynode();
extern long      __myptype();
extern long      __numnodes();
extern buf_c_el *_create_call();
extern int       _del_msg();
extern buf_m_el *_find_msg();
extern int       _handle_hcalls();
extern int       _ins_call();
extern int       _ins_hnd();
extern void      _rel_disable();
extern void      _rel_enable();
extern int       _rm_msg();
extern void      nx_perror();


/*****************************************************************************/
long _hrecvx
#ifdef ANSI
(long typesel, char *buf, long count, long nodesel, long ptypesel,
 void (*xhandler)(), long hparam)
#else
(typesel, buf, count, nodesel, ptypesel, xhandler, hparam)
long typesel;
char *buf;
long count;
long nodesel;
long ptypesel;
void (*xhandler)();
long hparam;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  buf_m_el *bme;
  
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if (((typesel != -1) && (typesel < 0)) || 
      ((typesel >= MAXUMT) && (typesel < MAXSMT)) ||
      (typesel >= MAXFMT)) 
  {
    errno = EQTYPE;
    return (-1);
  }
  
  if ((buf == (char *)0) && (count > 0))
  {
    errno = EQPBUF;
    return (-1);
  }
  
  if (count < 0)
  {
    errno = EQLEN;
    return (-1);
  }

  if (((nodesel != -1) && (nodesel < 0)) ||
      (nodesel > __numnodes()))
  {
    errno = EQNODE;
    return (-1);
  }

  if (((ptypesel != -1) && (ptypesel < 0)) ||
      (ptypesel > MAXPTYPE))
  {
    errno = EQPID;
    return (-1);
  }

  if (xhandler == (void (*)())0)
  {
    errno = EQHND;
    return (-1);
  }
  
  /* Disable incomming messages to avoid races */
  _rel_disable();
  
  if ((bce = _create_call(HRECVX,
                          typesel, buf, count,
                          __mynode(), __myptype(), nodesel, ptypesel,
                          xhandler,hparam,(long *)0)) == (buf_c_el *)0)
  {
    /* Enable incomming messgages */
    _rel_enable();
    
    return (-1);
  }

  if (_ins_call(bce) < 0)
  {
    /* Enable incomming messgages */
    _rel_enable();
    
    return (-1);
  }

  /* Check allready received messages */
  if ((bme = _find_msg(typesel, nodesel, ptypesel)) != (buf_m_el *)0)
  {
    /* There is a message */
    
    bce->status = CALL_DONE;

    /* Copy message */
    bce->msg_type = bme->msg_type;
    bce->s_node = bme->s_node;
    bce->s_ptype = bme->s_ptype;

    if (bce->count > bme->msg_len)
    {
      bce->errno = EQMSGSHORT;
      if (bme->msg_len > 0)
        memcpy((void *)bce->buf,(void *)bme->msg_ptr,(size_t)bme->msg_len);
    }
    else if (bce->count < bme->msg_len)
    {
      bce->errno = EQMSGLONG;
      if (bce->count > 0)
        memcpy((void *)bce->buf,(void *)bme->msg_ptr,(size_t)bce->count);
    }
    else if (bme->msg_len > 0)
      memcpy((void *)bce->buf,(void *)bme->msg_ptr,(size_t)bme->msg_len);
    
    bce->msg_len = bme->msg_len;

    /* Remove and delete message for message buffer */
    if (_rm_msg(bme) < 0)
    {
      /* Enable incomming messgages */
      _rel_enable();
      
      return (-1);
    }
    
    if (_del_msg(bme) < 0)
    {
      /* Enable incomming messgages */
      _rel_enable();
      
      return (-1);
    }
    
    /* Insert into the buffer for messages that need to be handled */
    if (_ins_hnd(bce) < 0)
    {
      /* Enable incomming messgages */
      _rel_enable();
      
      return (-1);
    }
    
    /* Handle the message if masktrap is enabled */
    if (_handle_hcalls() < 0)
    {
      /* Enable incomming messgages */
      _rel_enable();
      
      return (-1);
    }
    
  }


  /* Enable incomming messgages */
  _rel_enable();

  return (0);
}





/*****************************************************************************/
void hrecvx
#ifdef ANSI
(long typesel, char *buf, long count, long nodesel, long ptypesel,
 viod (*xhandler)(), long hparam)
#else
(typesel, buf, count, nodesel, ptypesel, xhandler, hparam)
long typesel;
char *buf;
long count;
long nodesel;
long ptypesel;
void (*xhandler)();
long hparam;
#endif
/*****************************************************************************/
{
  if (_hrecvx(typesel, buf, count, nodesel, ptypesel, xhandler, hparam) < 0)
  {
    nx_perror("hrecvx()");
    exit(-1);
  }
  
  return;
}

/*****************************************************************************/
long _hrecv
#ifdef ANSI
(long typesel, char *buf, long count, void (*handler)())
#else
(typesel, buf, count, handler)
long typesel;
char *buf;
long count;
void (*handler)();
#endif
/*****************************************************************************/
{
  return (_hrecvx(typesel, buf, count, (long)-1, (long)-1, handler, (long)0));
}



/*****************************************************************************/
void hrecv
#ifdef ANSI
(long typesel, char *buf, long count, void (*handler)())
#else
(typesel, buf, count, handler)
long typesel;
char *buf;
long count;
void (*handler)();
#endif
/*****************************************************************************/
{
  if (_hrecv(typesel, buf, count, handler) < 0)
  {
    nx_perror("hrecv()");
    exit(-1);
  }
  
  return;
}

