/******************************************************************************
*
*    Flush sent messages even on remote nodes
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  flushmsg.c,v
  1995/02/06 16:11:46
  1.4
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Flush sent messages even on remote nodes

  Available functions from this module: .....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "flushmsg.c,v 1.4 1995/02/06 16:11:46 lamberts Exp";
#endif

#include <sys/types.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __mynode();
extern long      __myptype();
extern long      __numnodes();
extern p_listel *_find_plistel();
extern int       _flush_aps();
extern int       _flush_msgs();
extern int       _had_ptype();
extern int       _rel_send();
extern void      _rel_disable();
extern void      _rel_enable();
extern void      nx_perror();


/*****************************************************************************/
int _d_flushmsg
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  msg_flushmsg *msg;

  msg = (msg_flushmsg *)msgd->msg_ptr;

  if (msg->node == __mynode())
  {
    if (msg->ptype != -1)
    {
      /* Forward the message to the process with that ptype */
      if (_find_plistel(msg->node,msg->ptype) != (p_listel *)0)
        if (_rel_send((long)FLUSHMSG,
                      msgd->msg_ptr,
                      msgd->msg_len,
                      msg->node,
                      msg->ptype) < 0)
          return (-1);
      return (0);
    }
                      
    /* Forward message to all processes */
    if (_flush_aps(msgd) < 0)
      return (-1);

    return (0);
  }
  
  /* Forward the message to the appropriate daemon */
  if (_rel_send((long)FLUSHMSG,
                msgd->msg_ptr,
                msgd->msg_len,
                msg->node,
                (long)DAEMON_PTYPE)< 0)
    return (-1);

  return (0);
}




/*****************************************************************************/
int _a_flushmsg
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  msg_flushmsg *msg;

  msg = (msg_flushmsg *)msgd->msg_ptr;

  if (_flush_msgs(msg->type,msg->ptype) < 0)
    return (-1);

  return (0);
}


      
  
/*****************************************************************************/
long _flushmsg
#ifdef ANSI
(long typesel, long nodesel, long ptypesel)
#else
(typesel, nodesel, ptypesel)
long typesel;
long nodesel;
long ptypesel;
#endif
/*****************************************************************************/
{
  long i;
  msg_flushmsg msg;

  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }

  if (((typesel != -1) && (typesel < 0)) || 
      ((typesel >= MAXUMT) && (typesel < MAXSMT)) ||
      (typesel >= MAXFMT)) 
  {
    errno = EQTYPE;
    return (-1);
  }

  if (((nodesel != -1) && (nodesel < 0)) ||
      (nodesel > __numnodes()))
  {
    errno = EQNODE;
    return (-1);
  }

  if (((ptypesel != -1) && (ptypesel < 0)) ||
      (ptypesel > MAXPTYPE))
  {
    errno = EQPID;
    return (-1);
  }

  _rel_disable();

  msg.ptype = ptypesel;
  msg.type = typesel;
  msg.f_node = __mynode();
  msg.f_pid = getpid();

  if (nodesel == -1)
  {
    for (i=0; i <= __numnodes(); i++)
      if ((ptypesel == -1) || (_had_ptype(ptypesel) == 0))
      {
        /* Send a FLUSHMSG message to all processes but myself */
        msg.node = i;
        
        if (_rel_send((long)FLUSHMSG,
                      (char *)&msg,
                      (long)sizeof(msg_flushmsg),
                      __mynode(),
                      (long)DAEMON_PTYPE) < 0)
        {
          _rel_enable();
          return (-1);
        }
      }
  }
  else if ((nodesel != __mynode()) ||
           (ptypesel == -1) || (_had_ptype(ptypesel) == 0))
  {
    /* Send a FLUSHMSG message to the appropriate node */
    msg.node = nodesel;
    
    if (_rel_send((long)FLUSHMSG,
                  (char *)&msg,
                  (long)sizeof(msg_flushmsg),
                  __mynode(),
                  (long)DAEMON_PTYPE) < 0)
    {
      _rel_enable();
      return (-1);
    }
  }
  
  if (((nodesel == -1) || (nodesel == __mynode())) &&
      ((ptypesel == -1) || (_had_ptype(ptypesel) == 1)))
  {
    if (_flush_msgs(typesel,ptypesel) < 0)
    {
      _rel_enable();
      return (-1);
    }
  }
  
  _rel_enable();
  return (0);
}





/*****************************************************************************/
void flushmsg
#ifdef ANSI
(long typesel, long nodesel, long ptypesel)
#else
(typesel, nodesel, ptypesel)
long typesel;
long nodesel;
long ptypesel;
#endif
/*****************************************************************************/
{
  if (_flushmsg(typesel, nodesel, ptypesel) < 0)
  {
    nx_perror("flushmsg()");
    exit(-1);
  }
  
  return;
}
  
