/******************************************************************************
*
*    Time in seconds (dclock)
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  dclock.c,v
  1993/10/19 16:41:49
  1.3
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: dclock()

  Available functions from this module: ...

******************************************************************************/
#ifndef lint
static char rcs_id[] = "dclock.c,v 1.3 1993/10/19 16:41:49 lamberts Exp";
#endif

#include <sys/time.h>
#include <stdlib.h>

extern void nx_perror();


/*************************************************************************
 * Gets elapsed time in seconds
 * - upon successful completion, returns the elapsed time and returns to
 *   the caller
 * - otherwise, returns -1 and indicate the error
 ************************************************************************/
double
#ifdef ANSI
_dclock(void)
#else
_dclock()
#endif
/************************************************************************/
{
  struct timeval t;
  struct timezone tz;
  
  if (gettimeofday(&t,&tz) < 0)
    return(-1.0);
  
  return ((double)((double)t.tv_sec + ((double)t.tv_usec*(double)0.000001)));

}

/*************************************************************************
 * Gets elapsed time in seconds
 * - upon successful completion, returns a double precision value, and 
 *   return control to the caller
 * - otherwise, displays an error message to stderr. and causes the calling
 *   process to terminate
 ************************************************************************/
double
#ifdef ANSI
dclock(void)
#else
dclock()
#endif
/************************************************************************/
{
  double res;

  if ((res = _dclock()) == -1.0) {
    nx_perror("dclock()");
    exit(-1);
  }
  return(res);
}
