/******************************************************************************
*
*    main() for programs linked with -lnx
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  main_lnx.c,v
  1994/03/14 10:54:13
  1.5
  Exp
  lamberts
 
  Authors: Stefan Lamberts, Susanna Schink

  Description:
  This file contains the main() procedure that is used if the program was
  compiled with the -lnx switch.

******************************************************************************/
#ifndef lint
static char rcs_id[] = "main_lnx.c,v 1.5 1994/03/14 10:54:13 lamberts Exp";
#endif

#include <stdlib.h>

extern int _applproc();
extern int _is_applproc();
extern int MAIN_TMPL();

char **_argv;
int _argc;



/*************************************************************************/
int
#ifdef ANSI
main(int argc, char **argv, char **envp)
#else
main(argc, argv, envp)
int argc;
char **argv;
char **envp;
#endif
/*************************************************************************/
{
  /* Set argument variables that are needed for FORTRAN stubs */
  _argv = argv;
  _argc = argc;
  
  if (_is_applproc(argc,argv))
    exit(_applproc(argc, argv, envp));
  else
    exit(MAIN_TMPL(argc, argv, envp));
}
    
