/******************************************************************************
*
*    main() for C++ programs linked with -nx
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  cxx_main_nx.C,v
  1995/02/10 13:23:50
  1.2
  Exp
  lamberts
 
  Authors: Geoffrey Furnish

  Description:
  This file contains the main() procedure that is used if the program was
  compiled with the -nx switch.

******************************************************************************/
#ifndef lint
static char rcs_id[] = "cxx_main_nx.C,v 1.2 1995/02/10 13:23:50 lamberts Exp";
#endif

#include <stdlib.h>

extern "C" {
    int _applproc( int argc, char **argv, char **envp );
    int _contrproc( int argc, char **argv, char **envp );
    int _is_applproc( int argc, char *argv[] );
};

char **_argv;
int _argc;

// If there is going to be any C++ code in the final executable, then the main
// function needs to be compiled with a C++ compiler.  This is to ensure that
// global constructors are run.

/*************************************************************************/
int main( int argc, char **argv, char **envp )
/*************************************************************************/
{
  /* Set argument variables that are needed for FORTRAN stubs */
  _argv = argv;
  _argc = argc;
  
  if (_is_applproc(argc,argv))
    exit(_applproc(argc, argv, envp));
  else
    exit(_contrproc(argc, argv, envp));
}
    
