/******************************************************************************
*
*    nxmalloc.h header file
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nxmalloc.h,v
  1995/02/09 10:53:27
  1.5
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: External function and procedure definition

******************************************************************************/
/* rcs_id: "nxmalloc.h,v 1.5 1995/02/09 10:53:27 lamberts Exp" */



#ifndef __nxmalloc_h
#define __nxmalloc_h

#include <malloc.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#if defined(__cplusplus) || defined(__STDC__)
#define _P(a) a
#else
#define _P(a) ()
#endif /* __cplusplus || __STDC__ */

void *nxlib_malloc   _P(( size_t size ));
int   nxlib_free     _P(( void *ptr ));
void *nxlib_realloc  _P(( void *ptr, size_t size ));
void *nxlib_calloc   _P(( size_t nelem, size_t elsize ));

#ifdef __cplusplus
};
#endif /* __cplusplus */

#ifdef LINUX
#undef malloc
#undef calloc
#endif

#define malloc    nxlib_malloc
#define free      nxlib_free
#define realloc   nxlib_realloc
#define calloc    nxlib_calloc

#endif /* __nxnalloc_h */
