/******************************************************************************
*
*    Fortran stubs.
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  fortran.c,v
  1994/12/30 16:30:11
  1.7
  Exp
  lamberts
 
  Authors: Norman Thomson

  Description:  Fortran stub for CPROBE_().

******************************************************************************/
#ifndef lint
static char rcs_id[] = "fortran.c,v 1.7 1994/12/30 16:30:11 lamberts Exp";
#endif

#include <stdlib.h>
#include <string.h>


#include "../include/sys/nxesize.h"
#include "../include/nxmalloc.h"


extern void cprobe();
extern void cprobex();
extern void crecv();
extern void crecvx();
extern void csend();
extern long csendrecv();
extern double dclock();
extern esize_t eadd();
extern long ecmp();
extern long ediv();
extern long emod();
extern esize_t emul();
extern esize_t esub();
extern void etos();
extern void flick();
extern void flushmsg();
extern void gcol();
extern void gcolx();
extern void gdhigh();
extern void gdlow();
extern void gdprod();
extern void gdsum();
extern void giand();
extern void gihigh();
extern void gilow();
extern void gior();
extern void giprod();
extern void gisum();
extern void gland();
extern void glor();
extern void gopf();
extern void gsendx();
extern void gshigh();
extern void gslow();
extern void gsprod();
extern void gssum();
extern void gsync();
extern void hrecv();
extern void hrecvx();
extern void hsend();
extern void hsendrecv();
extern void hsendx();
extern long infocount();
extern long infonode();
extern long infoptype();
extern long infotype();
extern long iprobe();
extern long iprobex();
extern long irecv();
extern long irecvx();
extern long isend();
extern long isendrecv();
extern void led();
extern long masktrap();
extern void msgcancel();
extern long msgdone();
extern void msgignore();
extern long msgmerge();
extern void msgwait();
extern long myhost();
extern long mynode();
extern long myptype();
extern long numnodes();
extern long nx_initve();
extern long nx_load();
extern void nx_perror();
extern long nx_loadve();
extern void nx_perror();
extern void nx_perror();
extern long nx_waitall();
extern void setptype();
extern esize_t stoe();

extern long _numnodes();

extern char **_argv;
extern char **environ;


/*****************************************************************************/
void cprobe_
#ifdef ANSI
(int *typesel)
#else
(typesel)
int *typesel;
#endif
{
  cprobe((long)*typesel);
  return;
}


/*****************************************************************************/
void cprobex_
# ifdef ANSI
(int *typesel, int *nodesel, int *ptypesel, int *info)
# else
(typesel, nodesel, ptypesel, info)
int *typesel;
int *nodesel;
int *ptypesel;
int *info;
# endif
{
  long tmpinfo[8];
  int i;
  
  cprobex((long)*typesel,
          (long)*nodesel,
          (long)*ptypesel,
          tmpinfo);

  for (i=0;i<8;i++)
    info[i]=(int)tmpinfo[i];
  
  return;
}


/*****************************************************************************/
void crecv_
# ifdef ANSI
(int *typesel, int *buf, int *count)
# else
(typesel, buf, count)
int *typesel;
int *buf;
int *count;
# endif
{
  crecv((long)*typesel,
        (char *)buf,
        (long)*count);
  return;
  
}



/*****************************************************************************/
void crecvx_
# ifdef ANSI
(int *typesel, int *buf, int *count, int *nodesel, int *ptypesel, int *info)
# else
(typesel, buf, count, nodesel, ptypesel, info)
int *typesel;
int *buf;
int *count;
int *nodesel;
int *ptypesel;
int *info;
# endif
{
  long tmpinfo[8];
  int i;
  
  crecvx((long)*typesel,
         (char *)buf,
         (long)*count,
         (long)*nodesel,
         (long)*ptypesel,
         tmpinfo);

  for (i=0;i<8;i++)
    info[i]=(int)tmpinfo[i];
  
  return;
}




/*****************************************************************************/
void csend_
# ifdef ANSI
(int *type, int *buf, int *count, int *node, int *ptype)
# else
(type, buf, count, node, ptype)
int *type;
int *buf;
int *count;
int *node;
int *ptype;
# endif
{
  csend((long)*type,
        (char *)buf,
        (long)*count,
        (long)*node,
        (long)*ptype);
  return;
}




/*****************************************************************************/
int csendrecv_
# ifdef ANSI
(int *type, int *sbuf, int *scount, int *node, int *ptype, int *typesel, int *rbuf, int *rcount)
# else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount)
int *type;
int *sbuf;
int *scount;
int *node;
int *ptype;
int *typesel;
int *rbuf;
int *rcount;
# endif
{
  return((int)csendrecv((long)*type,
                        (char *)sbuf,
                        (long)*scount,
                        (long)*node,
                        (long)*ptype,
                        (long)*typesel,
                        (char *)rbuf,
                        (long)*rcount));
}



/*****************************************************************************/
double
#ifdef ANSI
dclock_()
#else
dclock_()
#endif
{
  return(dclock());
}


/*****************************************************************************/
void eadd_
#ifdef ANSI
(int *e1, int *e2, int *eresult)
#else
(e1, e2, eresult)
int *e1;
int *e2;
int *eresult;
#endif
{
  esize_t te1;
  esize_t te2;
  esize_t res;

  te1.slow = (long)e1[0];
  te1.shigh = (long)e1[1];
  te2.slow = (long)e2[0];
  te2.shigh = (long)e2[1];

  res = eadd(te1,te2);

  eresult[0] = (int)res.slow;
  eresult[1] = (int)res.shigh;

  return;
}


/*****************************************************************************/
int ecmp_
#ifdef ANSI
(int *e1, int *e2)
#else
(e1, e2)
int *e1;
int *e2;
#endif
{
  esize_t te1;
  esize_t te2;

  te1.slow = (long)e1[0];
  te1.shigh = (long)e1[1];
  te2.slow = (long)e2[0];
  te2.shigh = (long)e2[1];

  return ((int)ecmp(te1,te2));
}


/*****************************************************************************/
void ediv_
#ifdef ANSI
(int *e, int *n, int *result)
#else
(e, n, result)
int *e;
int *n;
int *result;
#endif
{
  esize_t te;

  te.slow = (long)e[0];
  te.shigh = (long)e[1];

  *result = (int)ediv(te,(long)n);

  return;
}


/*****************************************************************************/
void emod_
#ifdef ANSI
(int *e, int *n, int *result)
#else
(e, n, result)
int *e;
int *n;
int *result;
#endif
{
  esize_t te;

  te.slow = (long)e[0];
  te.shigh = (long)e[1];

  *result = (int)emod(te,(long)n);

  return;
}


/*****************************************************************************/
void emul_
#ifdef ANSI
(int *e, int *n, int *eresult)
#else
(e, n, eresult)
int *e;
int *n;
int *eresult;
#endif
{
  esize_t te;
  esize_t res;

  te.slow = (long)e[0];
  te.shigh = (long)e[1];

  res = emul(te,(long)n);

  eresult[0] = (int)res.slow;
  eresult[1] = (int)res.shigh;

  return;
}


/*****************************************************************************/
void esub_
#ifdef ANSI
(int *e1, int *e2, int *eresult)
#else
(e1, e2, eresult)
int *e1;
int *e2;
int *eresult;
#endif
{
  esize_t te1;
  esize_t te2;
  esize_t res;

  te1.slow = (long)e1[0];
  te1.shigh = (long)e1[1];
  te2.slow = (long)e2[0];
  te2.shigh = (long)e2[1];
  res = esub(te1,te2);

  eresult[0] = (int)res.slow;
  eresult[1] = (int)res.shigh;

  return;
}


/*****************************************************************************/
void etos_
#ifdef ANSI
(int *e, char *s)
#else
(e, s)
int *e;
char *s;
#endif
/*****************************************************************************/
{
  esize_t te;

  te.slow = (long)e[0];
  te.shigh = (long)e[1];

  etos(te,s);

  return;
}


/*****************************************************************************/
void
#ifdef ANSI
flick_()
#else
flick_()
#endif
{
  flick();
  return;
}




/*****************************************************************************/
void flushmsg_
# ifdef ANSI
(int *typesel, int *nodesel, int *ptypesel)
# else
(typesel, nodesel, ptypesel)
int *typesel;
int *nodesel;
int *ptypesel;
# endif
{
  flushmsg((long)*typesel,
           (long)*nodesel,
           (long)*ptypesel);
  return;
}




/*****************************************************************************/
void gcol_
# ifdef ANSI
(int *x, int *xlen, int *y, int *ylen, int *ncnt)
# else
( x, xlen, y, ylen, ncnt )
int *x;
int *xlen;
int *y;
int *ylen;
int *ncnt;
# endif
{
  long tmpncnt;

  gcol((char *)x,
       (long)*xlen,
       (char *)y,
       (long)*ylen,
       &tmpncnt);

  *ncnt=(int)tmpncnt;
  
  return;
}




/*****************************************************************************/
void gcolx_
# ifdef ANSI
( int *x, int *xlens, int *y )
# else
( x, xlens, y )
int *x;
int *xlens;
int *y;
# endif
{
  long *tmpxlens = (long *)0;
  int i;
  
  if ((tmpxlens = (long *)malloc((size_t)(sizeof(long)*(_numnodes()))))
      == (long *)0)
  {
    nx_perror("gcolx()");
    exit(-1);
  }
  
  for (i=0;i<_numnodes();i++)
    tmpxlens[i]=(long)xlens[i];

  gcolx((char *)x,
        tmpxlens,
        (char *)y);

  return;
}




/*****************************************************************************/
void gdhigh_
# ifdef ANSI
( double *x, int *n, double *work )
# else
( x, n, work )
double *x;
int *n;
double *work;
# endif
{
  gdhigh((double *)x,
         (long)*n,
         (double *)work );
  return;
  
}



/*****************************************************************************/
void gdlow_
# ifdef ANSI
( double *x, int *n, double *work )
# else
( x, n, work )
double *x;
int *n;
double *work;
# endif
{
  gdlow((double *)x,
        (long)*n,
        (double *)work);
  
  return;
}




/*****************************************************************************/
void   gdprod_
# ifdef ANSI
( double *x, int *n, double *work )
# else
( x, n, work )
double *x;
int *n;
double *work;
# endif
{
  gdprod((double *)x,
         (long)*n,
         (double *)work);
  return;
}



/*****************************************************************************/
void gdsum_
# ifdef ANSI
( double *x, int *n, double *work )
# else
( x, n, work )
double *x;
int *n;
double *work;
# endif
{
  gdsum((double *)x,
        (long)*n,
        (double *)work);
  
  return;
}



/*****************************************************************************/
void giand_
# ifdef ANSI
( int *x, int *n, int *work )
# else
( x, n, work )
int *x;
int *n;
int *work;
# endif
{
  long *tmpx = (long *)0;
  long *tmpwork = (long *)0;
  int i;
  
  if (*n >= 0)
  {
    if ((tmpx = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  
    if ((tmpwork = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  }
  
  for (i=0;i<*n;i++)
    tmpx[i]=(long)x[i];

  giand(tmpx, (long)*n, tmpwork );

  for (i=0;i<*n;i++)
    x[i]=(int)tmpx[i];

  if (*n >= 0)
  {
    free((void *)tmpx);
    free((void *)tmpwork);
  }
  
  return;
}





/*****************************************************************************/
void gihigh_
# ifdef ANSI
( int *x, int *n, int *work )
# else
( x, n, work )
int *x;
int *n;
int *work;
# endif
{
  long *tmpx = (long *)0;
  long *tmpwork = (long *)0;
  int i;
  
  if (*n >= 0)
  {
    if ((tmpx = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  
    if ((tmpwork = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  }
  
  for (i=0;i<*n;i++)
    tmpx[i]=(long)x[i];

  gihigh(tmpx, (long)*n, tmpwork );

  for (i=0;i<*n;i++)
    x[i]=(int)tmpx[i];

  if (*n >= 0)
  {
    free((void *)tmpx);
    free((void *)tmpwork);
  }
  
  return;
}





/*****************************************************************************/
void gilow_
# ifdef ANSI
( int *x, int *n, int *work )
# else
( x, n, work )
int *x;
int *n;
int *work;
# endif
{
  long *tmpx = (long *)0;
  long *tmpwork = (long *)0;
  int i;
  
  if (*n >= 0)
  {
    if ((tmpx = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  
    if ((tmpwork = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  }
  
  for (i=0;i<*n;i++)
    tmpx[i]=(long)x[i];

  gilow(tmpx, (long)*n, tmpwork );

  for (i=0;i<*n;i++)
    x[i]=(int)tmpx[i];

  if (*n >= 0)
  {
    free((void *)tmpx);
    free((void *)tmpwork);
  }
  
  return;
}





/*****************************************************************************/
void gior_
# ifdef ANSI
( int x, int *n, int work )
# else
( x, n, work )
int *x;
int *n;
int *work;
# endif
{
  long *tmpx = (long *)0;
  long *tmpwork = (long *)0;
  int i;
  
  if (*n >= 0)
  {
    if ((tmpx = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  
    if ((tmpwork = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  }
  
  for (i=0;i<*n;i++)
    tmpx[i]=(long)x[i];

  gior(tmpx, (long)*n, tmpwork );

  for (i=0;i<*n;i++)
    x[i]=(int)tmpx[i];

  if (*n >= 0)
  {
    free((void *)tmpx);
    free((void *)tmpwork);
  }
  
  return;
}





/*****************************************************************************/
void giprod_
# ifdef ANSI
( int *x, int *n, int *work )
# else
( x, n, work )
int *x;
int *n;
int *work;
# endif
{
  long *tmpx = (long *)0;
  long *tmpwork = (long *)0;
  int i;
  
  if (*n >= 0)
  {
    if ((tmpx = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  
    if ((tmpwork = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  }
  
  for (i=0;i<*n;i++)
    tmpx[i]=(long)x[i];

  giprod(tmpx, (long)*n, tmpwork );

  for (i=0;i<*n;i++)
    x[i]=(int)tmpx[i];

  if (*n >= 0)
  {
    free((void *)tmpx);
    free((void *)tmpwork);
  }
  
  return;
}





/*****************************************************************************/
void gisum_
# ifdef ANSI
( int *x, int *n, int *work )
# else
( x, n, work )
int *x;
int *n;
int *work;
# endif
{
  long *tmpx = (long *)0;
  long *tmpwork = (long *)0;
  int i;
  
  if (*n >= 0)
  {
    if ((tmpx = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  
    if ((tmpwork = (long *)malloc((size_t)(sizeof(long)*(*n)))) == (long *)0)
    {
      nx_perror("giand()");
      exit(-1);
    }
  }
  
  for (i=0;i<*n;i++)
    tmpx[i]=(long)x[i];

  gisum(tmpx, (long)*n, tmpwork );

  for (i=0;i<*n;i++)
    x[i]=(int)tmpx[i];

  if (*n >= 0)
  {
    free((void *)tmpx);
    free((void *)tmpwork);
  }
  
  return;
}




/*****************************************************************************/
void gland_
# ifdef ANSI
(long *x, long *n, long *work )
# else
( x, n, work )
long *x;
long *n;
long *work;
# endif
{
  gland( (long *)x, (long)*n, (long *)work );
  return;
}




/* LAMBO: Wie konvertiert man LOGICALs von Fortran in longs ? */
/*****************************************************************************/
void glor_
# ifdef ANSI
(long x, long *n, long work )
# else
( x, n, work )
long *x;
long *n;
long *work;


# endif
{
  glor( (long *)x, (long)*n, (long *)work );
  return;
}

/* LAMBO: Wie konvertiert man LOGICALs von Fortran in longs ? */




/*****************************************************************************/
void gopf_
# ifdef ANSI
( int *x, int *xlen, int *work, long (*name)() );
# else
( x, xlen, work, name )
int *x;
int *xlen;
int *work;
long (*name)();
# endif
{
  gopf( (char *)x, (long)*xlen, (char *)work, name );
  return;
}





/*****************************************************************************/
void gsendx_
# ifdef ANSI
(int *type, int *buf, int *count, int *nodes, int *nodecount )
# else
(type, buf, count, nodes, nodecount )
int *type;
int *buf;
int *count;
int *nodes;
int *nodecount;
# endif
{
  long *tmpnodes = (long *)0;
  int i;
  
  if (*nodecount >= 0)
  {
    if ((tmpnodes = (long *)malloc((size_t)(sizeof(long)*(*nodecount))))
      == (long *)0)
    {
      nx_perror("gsendx()");
      exit(-1);
    }
  }
  
  for (i=0;i<*nodecount;i++)
    tmpnodes[i]=(long)nodes[i];
  
  gsendx((long)*type,
         (char *)buf,
         (long)*count,
         tmpnodes,
         (long)*nodecount);
  
  if (*nodecount >= 0)
  {
    free((void *)tmpnodes);
  }
  
  return;
}



/*****************************************************************************/
void gshigh_
# ifdef ANSI
( float *x, int *n, float *work )
# else
( x, n, work )
float *x;
int *n;
float *work;
# endif
{
  gshigh( (float *)x, (long)*n, (float *)work );
  return;
}




/*****************************************************************************/
void gslow_
# ifdef ANSI
( float *x, int *n, float *work )
# else
( x, n, work )
float *x;
int *n;
float *work;
# endif
{
  gslow( (float *)x, (long)*n, (float *)work );
  return;
}




/*****************************************************************************/
void gsprod_
# ifdef ANSI
( float *x, int *n, float *work )
# else
( x, n, work )
float *x;
int *n;
float *work;
# endif
{
  gsprod( (float *)x, (long)*n, (float *)work );
  return;
}





/*****************************************************************************/
void gssum_
# ifdef ANSI
( float *x, int *n, float *work )
# else
( x, n, work )
float *x;
int *n;
float *work;
# endif
{
  gssum( (float *)x, (long)*n, (float *)work );
  return;
}




/*****************************************************************************/
void gsync_
#ifdef ANSI
(void)
#else
()
#endif
{
  gsync();
  return;
}





/*****************************************************************************/
void hrecv_
# ifdef ANSI
(int *typesel, int *buf, int *count, void (*handler)() )
# else
(typesel, buf, count, handler )
int *typesel;
int *buf;
int *count;
void (*handler)();
# endif
{
  hrecv( (long)*typesel, (char *)buf, (long)*count, handler);
  return;
}




/*****************************************************************************/
void hrecvx_
# ifdef ANSI
(int *typesel, int *buf, int *count, int *nodesel, int *ptypesel, void (*handler)(), int *hparam )
# else
(typesel, buf, count, nodesel, ptypesel, handler, hparam )
int *typesel;
int *buf;
int *count;
int *nodesel;
int *ptypesel;
void (*handler)();
int *hparam;
# endif
{
  hrecvx((long)*typesel,
         (char *)buf,
         (long)*count,
         (long)*nodesel,
         (long)*ptypesel,
         handler,
         (long)*hparam );
  
  return;
}






/*****************************************************************************/
void hsend_
# ifdef ANSI
(int *type, int *buf, int *count, int *node, int *ptype, void (*handler)() )
# else
(type, buf, count, node, ptype, handler )
int *type;
int *buf;
int *count;
int *node;
int *ptype;
void (*handler)();
# endif
{
  hsend((long)*type,
        (char *)buf,
        (long)*count,
        (long)*node,
        (long)*ptype,
        handler);
  
  return;
}






/*****************************************************************************/
void hsendrecv_
# ifdef ANSI
(int *type, int *sbuf, int *scount, int *node, int *ptype, int *typesel, int *rbuf, int *rcount, void (*handler)() )
# else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount, handler )
int *type;
int *sbuf;
int *scount;
int *node;
int *ptype;
int *typesel;
int *rbuf;
int *rcount;
void (*handler)();
# endif
{
  hsendrecv((long)*type,
            (char *)sbuf,
            (long)*scount,
            (long)*node,
            (long)*ptype,
            (long)*typesel,
            (char *)rbuf,
            (long)*rcount,
            handler);
  
  return;
}






/*****************************************************************************/
void hsendx_
#ifdef ANSI
(int *type, int *buf, int *count, int *node, int *ptype, void (*handler)(), int *hparam )
#else
(type, buf, count, node, ptype, handler, hparam )
int *type;
int *buf;
int *count;
int *node;
int *ptype;
void (*handler)();
int *hparam;
#endif
{
  hsendx((long)*type,
         (char *)buf,
         (long)*count,
         (long)*node,
         (long)*ptype,
         handler,
         (long)*hparam);
  
  return;
}



/*****************************************************************************/
int infocount_
#ifdef ANSI
(void)
#else
()
#endif
{
  return((int)infocount());
}




/*****************************************************************************/
int infonode_
#ifdef ANSI
(void)
#else
()
#endif
{
  return((int)infonode());
}




/*****************************************************************************/
int infoptype_
#ifdef ANSI
(void)
#else
()
#endif
{
  return((int)infoptype());
}



/*****************************************************************************/
int infotype_
#ifdef ANSI
(void)
#else
()
#endif
{
  return((int)infotype());
}





/*****************************************************************************/
int iprobe_
#ifdef ANSI
(int *typesel)
#else
(typesel)
int *typesel;
#endif
{
  return((int)iprobe((long)*typesel));
}






/*****************************************************************************/
int iprobex_
#ifdef ANSI
(int *typesel, int *nodesel, int *ptypesel, int *info)
#else
(typesel, nodesel, ptypesel,info)
int *typesel;
int *nodesel;
int *ptypesel;
int *info;
#endif
{
  long tmpinfo[8];
  long res;
  int i;
  
  res = iprobex((long)*typesel,
                (long)*nodesel,
                (long)*ptypesel,
                tmpinfo);

  for (i=0;i<8;i++)
    info[i]=(int)tmpinfo[i];

  return ((int)res);
}




/*****************************************************************************/
int irecv_
#ifdef ANSI
(int *typesel, int *buf, int *count)
#else
(typesel, buf, count)
int *typesel;
int *buf;
int *count;
#endif
{
  return((int)irecv((long)*typesel, (char *)buf, (long)*count));
}




/*****************************************************************************/
int irecvx_
#ifdef ANSI
(int *typesel, int *buf, int *count, int *nodesel, int *ptypesel, int *info)
#else
(typesel, buf, count, nodesel, ptypesel, info)
int *typesel;
int *buf;
int *count;
int *nodesel;
int *ptypesel;
int *info;
#endif
{
  long tmpinfo[8];
  long res;
  int i;
  
  res = irecvx((long)*typesel,
               (char *)buf,
               (long)*count,
               (long)*nodesel,
               (long)*ptypesel,
               tmpinfo);

  for (i=0;i<8;i++)
    info[i]=(int)tmpinfo[i];

  return (res);
}




/*****************************************************************************/
int isend_
#ifdef ANSI
(int *type, int *buf, int *count, int *node, int *ptype)
#else
(type, buf, count, node, ptype)
int *type;
int *buf;
int *count;
int *node;
int *ptype;
#endif
{
  return((int)isend((long)*type,
                    (char *)buf,
                    (long)*count,
                    (long)*node,
                    (long)*ptype));
}



/*****************************************************************************/
int isendrecv_
#ifdef ANSI
(int *type, int *sbuf, int *scount, int *node, int *ptype, int *typesel, int *rbuf, int *rcount)
#else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount)
int *type;
int *sbuf;
int *scount;
int *node;
int *ptype;
int *typesel;
int *rbuf;
int *rcount;
#endif
{
  return((int)isendrecv((long)*type,
                        (char *)sbuf,
                        (long)*scount,
                        (long)*node,
                        (long)*ptype,
                        (long)*typesel,
                        (char *)rbuf,
                        (long)*rcount));
}



/*****************************************************************************/
void led_
#ifdef ANSI
(int *state)
#else
(state)
int *state;
#endif
{
  led((long)*state);
  return;
}




/*****************************************************************************/
int masktrap_
#ifdef ANSI
(int *state)
#else
(state)
int *state;
#endif
{
  return((int)masktrap((long)*state));
}




/*****************************************************************************/
void msgcancel_
#ifdef ANSI
(int *mid)
#else
(mid)
int *mid;
#endif
{
  msgcancel((long)*mid);
  return;
}




/*****************************************************************************/
int msgdone_
#ifdef ANSI
(int *mid)
#else
(mid)
int *mid;
#endif
{
  return((int)msgdone((long)*mid));
}




/*****************************************************************************/
void msgignore_
#ifdef ANSI
(int *mid)
#else
(mid)
int *mid;
#endif
{
  msgignore((long)*mid);
  return;
}




/*****************************************************************************/
int msgmerge_
#ifdef ANSI
(int *mid1, int *mid2)
#else
(mid1, mid2)
int *mid1;
int *mid2;
#endif
{
  return((int)msgmerge((long)*mid1, (long)*mid2));
}




/*****************************************************************************/
void msgwait_
#ifdef ANSI
(int *mid)
#else
(mid)
int *mid;
#endif
{
  msgwait((long)*mid);
  return;
}




/*****************************************************************************/
int myhost_
#ifdef ANSI
(void)
#else
()
#endif
{
  return((int)myhost());
}



/*****************************************************************************/
int mynode_
#ifdef ANSI
(void)
#else
()
#endif
{
  return((int)mynode());
}



/*****************************************************************************/
int myptype_
#ifdef ANSI
(void)
#else
()
#endif
{
  return((int)myptype());
}



/*****************************************************************************/
int numnodes_
#ifdef ANSI
(void)
#else
()
#endif
{
  return((int)numnodes());
}




/*****************************************************************************/
int nx_initve_
#ifdef ANSI
(char *partition, int *size, char *account, int *argc, int *argv)
#else
(partition, size, account, argc, argv)
char *partition;
int *size;
char *account;
int *argc;
int *argv;
#endif
{
  long tmpargc = (long)*argc;
  long res;
  
  res = nx_initve(partition, (long)*size, account, &tmpargc, _argv);
  
  *argc=tmpargc;
  return ((int)res);
}




/*****************************************************************************/
int nx_load_
#ifdef ANSI
(int *node_list, int *nnodes, int *ptype, int *pid_list, char *pathname)
#else
(node_list, nnodes, ptype, pid_list, pathname)
int *node_list;
int *nnodes;
int *ptype;
int *pid_list;
char *pathname;
#endif
{
  long *tmpnode_list;
  long *tmppid_list = (long *)0;
  int i;
  long res;
  
  if (*nnodes >= 0)
  {
    if ((tmpnode_list = (long *)malloc((size_t)(sizeof(long)*(*nnodes))))
        == (long *)0)
    {
      nx_perror("nx_load()");
      exit(-1);
    }
    for (i=0;i<*nnodes;i++)
      tmpnode_list[i]=(long)node_list[i];
  }
  
  if ((tmppid_list = (long *)malloc((size_t)(sizeof(long)
                                             * ((*nnodes >= 0)
                                                ? (*nnodes)
                                                : numnodes()))))
      == (long *)0)
  {
    nx_perror("nx_load()");
    exit(-1);
  }

  res = nx_load(tmpnode_list,
                (long)*nnodes,
                (long)*ptype,
                tmppid_list,
                pathname);

  for (i=0; i< (*nnodes >= 0 ? *nnodes : numnodes());i++)
    pid_list[i]=(int)tmppid_list[i];
  
  if (*nnodes >= 0)
  {
    free((void *)tmpnode_list);
  }
  
  free((void *)tmppid_list);

  return ((int)res);
}




/*****************************************************************************/
int nx_loadve_
#ifdef ANSI
(int *node_list, int *nnodes, int *ptype, int *pid_list, char *path, int *argvec, int *envp);
#else
(node_list, nnodes, ptype, pid_list, path, argvec, envp)
int *node_list;
int *nnodes;
int *ptype;
int *pid_list;
char *path;
int *argvec;
int *envp;
#endif
{
  char *argv[2];
  long *tmpnode_list = (long *)0;
  long *tmppid_list;
  int i;
  long res;
  
  if (*nnodes >= 0)
  {
    if ((tmpnode_list = (long *)malloc((size_t)(sizeof(long)*(*nnodes))))
        == (long *)0)
    {
      nx_perror("nx_load()");
      exit(-1);
    }
    for (i=0;i<*nnodes;i++)
      tmpnode_list[i]=(long)node_list[i];
  }
  
  if ((tmppid_list = (long *)malloc((size_t)(sizeof(long)
                                             * ((*nnodes >= 0)
                                                ? (*nnodes)
                                                : numnodes()))))
      == (long *)0)
  {
    nx_perror("nx_load()");
    exit(-1);
  }

  if ((argv[0] = strrchr(path,'/')) == (char *)0) /* find last occurence of '/'
                                                   */
    argv[0] = path;
  else
    argv[0]++;                  /* name of exececutable
                                   starts right after last '/' */
  argv[1] = (char *)0;
 
  res = nx_loadve(tmpnode_list,
                  (long)*nnodes,
                  (long)*ptype,
                  tmppid_list,
                  path,
                  argv,
                  environ);

  for (i=0; i< (*nnodes >= 0 ? *nnodes : numnodes());i++)
    pid_list[i]=(int)tmppid_list[i];
  
  if (*nnodes >= 0)
  {
    free((void *)tmpnode_list);
  }
  
  free((void *)tmppid_list);

  return ((int)res);
}




/*****************************************************************************/
void nx_perror_
#ifdef ANSI
(char *string)
#else
(string)
char *string;
#endif
{
  nx_perror(string);
  return;
}




/*****************************************************************************/
int nx_waitall_
#ifdef ANSI
(void)
#else
()
#endif
{
  return ((int)nx_waitall());
}






/*****************************************************************************/
void setptype_
#ifdef ANSI
(int *ptype)
#else
(ptype)
int *ptype;
#endif
{
  setptype((long)*ptype);
  return;
}



/*****************************************************************************/
void stoe_
#ifdef ANSI
(char *s, int *e)
#else
(s, e)
char *s;
int *e;
#endif
/*****************************************************************************/
{
  esize_t te;

  te = stoe(s);

  e[0] = (int)te.slow;
  e[1] = (int)te.shigh;

  return;
}


