/******************************************************************************

  setptype.c,v
  1993/10/29 09:54:00
  1.2
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description:

  Set ptypes.

******************************************************************************/
#ifndef lint
static char rcs_id[] = "setptype.c,v 1.2 1993/10/29 09:54:00 lamberts Exp";
#endif

#include <stdio.h>
#include <errno.h>


int main 
#ifdef ANSI
(int argc, char **argv)
#else
(argc, argv)
int argc;
char **argv;
#endif
{
  long i;
  long max;

  switch (argc)
  {
  case 2:
    max = 1;
    break;
  case 3:
    max = atol(argv[2]);
    break;
  default:
    fprintf(stderr,"usage: %s Name [max ptype]\n",argv[0]);
    exit(1);
  }
  

  fprintf(stdout,"%s (N: %ld P: %ld) Set ptype from 0 to %ld for the first time\n",
          argv[1],mynode(),myptype(), max);

  for (i = 0; i <= max; i++)
  {
    if (_setptype(i) < 0)
    {
      fprintf(stdout,"%s (N: %ld P: %ld) Ptype not set to %ld due to error: %d\n",
              argv[1], mynode(),myptype(), i, errno);
      nx_perror("_setptype()");
    }
    else 
      fprintf(stdout,"%s (N: %ld P: %ld) Ptype set to %ld\n",
              argv[1], mynode(),myptype(), i);
  }
  

  fprintf(stdout,"%s (N: %ld P: %ld) Set ptype from 0 to %ld for the second time\n",
          argv[1], mynode(),myptype(), max);

  for (i = 0; i <= max; i++)
  {
    if (_setptype(i) < 0)
    {
      fprintf(stdout,"%s (N: %ld P: %ld) Ptype not set to %ld due to error: %d\n",
              argv[1], mynode(),myptype(), i, errno);
      nx_perror("_setptype()");
    }
    else 
      fprintf(stdout,"%s (N: %ld P: %ld) Ptype set to %ld\n",
              argv[1], mynode(),myptype(), i);
  }
  

  exit(0);
}
