/******************************************************************************

******************************************************************************/
#ifndef lint
static char rcs_id[] = "pingpong.c,v 1.5 1994/01/25 14:53:54 lamberts Exp";
#endif


#include <stdio.h>
#include <nx.h>
#include <math.h>

#define BUFFSIZE 1500000

char buffer[BUFFSIZE];


/*****************************************************************************/
void cpingpong(count, size)
int count;
long size;
/*****************************************************************************/
{  
  int i;
  double begin;
  double total = 0.0;
  double tsq = 0.0;
  double time, aver, std;
  double max = -1.0;
  double min = -1.0;

  if (mynode() == 0)
  {
    gsync();
    for (i=0; i < count; i++)
    {
      begin = dclock();
      csend(0,buffer,size,1,0);
      crecv(0,buffer,size);
      time =  (dclock() - begin);
      total += time;
      tsq += time*time;
      if ((max == -1.0) || (time > max))
        max = time;
      if ((min == -1.0) || (time < min))
        min = time;
    }
    
    aver = (total/(double)count);
    std = sqrt((tsq/(double)count)-(aver*aver));
    fprintf(stdout,"%4d |%8ld |%9.4f |%9.4f |%9.4f |%9.4f |%9.4f |%7.1f\n",
           count,
           size,
           total,
           max,
           min,
           aver,
           std,
           (std/aver)*100.0);
    
    fflush(stdout);
  }
  else if (mynode() == 1)
  {
    gsync();
    for (i=0; i < count; i++)
    {
      crecv(0,buffer,size);
      csend(0,buffer,size,0,0);
    }
  }
  else
  {
    gsync();
  }
}  




/*****************************************************************************/
int main(argc, argv)
int argc;
char **argv;
/*****************************************************************************/
{
  int iters;
  long max;
  long min;
  long step;
  long l;

  if (argc != 5)
  {
    fprintf(stderr,"Usage: %s Iterations Min Max Step\n",argv[0]);
    exit(1);
  }

  if ((iters = atoi(argv[1])) <= 0) 
  {
    fprintf(stderr,"%s: Iterations must be greater 0\n",argv[0]);
    exit(1);
  }    
  if ((min = atol(argv[2])) < 0)
  {
    fprintf(stderr,"%s: Min message length must be greater or equal 0\n",argv[0]);
    exit(1);
  }    
  if ((max = atol(argv[3])) < 0)
  {
    fprintf(stderr,"%s: Max message length must be greater or equal 0\n",argv[0]);
    exit(1);
  }    
  if ((step = atol(argv[4])) <= 0)
  {
    fprintf(stderr,"%s: Step must be greater 0\n",argv[0]);
    exit(1);
  }    
    
  if (mynode() == 0)
    printf("Initialization\n");

  cpingpong(1,(long)0);

  if (mynode() == 0)
  {
    fprintf(stdout,"Iter |   Bytes | Tot[sec] | Max[sec] | Min[sec] | Av [sec] | StD[sec] | S/A[%%]\n");
    fflush(stdout);
  }
  
  for (l = min; (l <= max) && (l <= BUFFSIZE); l += step)
  {
    cpingpong(iters,l);
  }
  
  exit(0);
}
