/******************************************************************************

  pingpong.c,v
  1995/02/10 08:33:21
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description:

  Pinpong program

******************************************************************************/
#ifndef lint
static char rcs_id[] = "pingpong.c,v 1.6 1995/02/10 08:33:21 lamberts Exp";
#endif


#include <stdio.h>
#include <nx.h>

#define BUFFSIZE 1500000

char buffer[BUFFSIZE];

/*****************************************************************************/
void cpingpong(count, size)
int count;
long size;
/*****************************************************************************/
{  
  int i;
  double begin;
  double total = 0.0;
  

  if (mynode() == 0)
  {
    gsync();
    for (i=0; i < count; i++)
    {
      begin = dclock();
      csend(0,buffer,size,1,0);
      crecv(0,buffer,size);
      total += (dclock() - begin);
    }
    printf("%10d |%16ld |%17.6f |%18.6f\n",
           count,
           size,
           total,
           (total/(double)count));
    
  }
  else if (mynode() == 1)
  {
    gsync();
    for (i=0; i < count; i++)
    {
      crecv(0,buffer,size);
      csend(0,buffer,size,0,0);
    }
  }
  else
  {
    gsync();
  }
}  




/*****************************************************************************/
int main(argc, argv)
int argc;
char **argv;
/*****************************************************************************/
{
  int iters;
  long max;
  long min;
  long step;
  long l;

  if (argc != 5)
  {
    fprintf(stderr,"Usage: %s Iterations Min Max Step\n",argv[0]);
    exit(1);
  }

  if ((iters = atoi(argv[1])) <= 0) 
  {
    fprintf(stderr,"%s: Iterations must be greater 0\n",argv[0]);
    exit(1);
  }    
  if ((min = atol(argv[2])) < 0)
  {
    fprintf(stderr,"%s: Min message length must be greater or equal 0\n",argv[0]);
    exit(1);
  }    
  if ((max = atol(argv[3])) < 0)
  {
    fprintf(stderr,"%s: Max message length must be greater or equal 0\n",argv[0]);
    exit(1);
  }    
  if ((step = atol(argv[4])) <= 0)
  {
    fprintf(stderr,"%s: Step must be greater 0\n",argv[0]);
    exit(1);
  }    
    
  if (mynode() == 0)
    printf("Initialization\n");

  cpingpong(1,(long)0);

  if (mynode() == 0)
    printf("Iterations | Number of Bytes | Total Time (sec) | Average Time (sec)\n");
  
  
  for (l = min; (l <= max) && (l <= BUFFSIZE); l += step)
  {
    cpingpong(iters,l);
  }
  
  exit(0);
}
