/******************************************************************************
*
*    nxdaemon source file
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nxdaemon.c,v
  1995/02/06 16:08:36
  1.12
  Exp
  lamberts
 
  Authors: Stefan Lamberts, Susanna Schink

  Description: This file cointains the main() procedure of nxdaemons.

  Available functions from this module: ...

******************************************************************************/
#ifndef lint
static char rcs_id[] = "nxdaemon.c,v 1.12 1995/02/06 16:08:36 lamberts Exp";
#endif

#include <sys/types.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef HP_UX
#include <malloc.h>             /* For mallopt() */
#endif

#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

#define NO_ARG 8

extern void __setnode();
extern void __setnumnodes();
extern long __setptype();
extern void _ap_sig_child();
extern int  _rel_d_setup();
extern void _rel_wait_msg();
extern void nx_perror();

extern int __tcpbufsize;

static int keep_running = 1;


static int term_daem
#ifdef ANSI
(void)
#else
()
#endif
{
  return (keep_running == 1);
}





/*************************************************************************/
int
#ifdef ANSI
main(int argc, char **argv)
#else
main(argc, argv)
int argc;
char **argv;
#endif
/*************************************************************************/
{
  char *cp_hname;
  u_short cp_port;
  pid_t cp_pid;

#ifdef BSD_SIG
  struct sigvec vec;
#else
  struct sigaction sigact;
#endif

#ifdef HALTDAEMON
  int dbg = 1;

  while (dbg);
#endif

  if (argc != NO_ARG)
  {
    fprintf(stderr,"%s: usage: %s <nodenumber> <host of controlling process> <portnumber of controlling process> <number of nodes> <pid of contolling process> <pathname> <tcp buffer size>\n",argv[0],argv[0]);
    exit(-1);
  }

  /* Change directory if a path is specified */
  if (chdir(argv[6]) != 0)
  {
    nx_perror("chdir()");
    exit(-1);
  }

  /* Become process group leader */
#ifndef RS6K_AIX                /* This doesn't work remote on RS6K_AIX */
  if (setpgid((pid_t)0,(pid_t)0) < 0)
  {
    nx_perror("setpgid()");
    exit(-1);
  }
#endif

  /* Block Signals during memmory allocating calls */
#ifdef HP_UX
  if (mallopt(M_BLOCK,1) != 0)
    exit(-1);
#endif

  if (__setptype((long)DAEMON_PTYPE) < 0)
  {
    nx_perror("__setptype()");
    exit(-1);
  }

  __setnode(atol(argv[1]));

  __setnumnodes(atol(argv[4]));

  cp_hname = argv[2];

  if ((__tcpbufsize = atoi(argv[7])) <= 0)
  {
    nx_perror("Invalid TCP buffer size");
    exit(-1);
  }

  /* SIGCHLD handler for application processes */

#ifdef BSD_SIG
  vec.sv_handler = _ap_sig_child;
  vec.sv_flags = 0;
  vec.sv_mask = sigmask(SIGIO) |
    sigmask(SIGCHLD) |
      sigmask(SIGTSTP) |
        sigmask(SIGCONT);
  
  if (sigvec(SIGCHLD, &vec, (struct sigvec *)0) != 0)
    exit(-1);
#else
  if ((sigemptyset(&sigact.sa_mask) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGIO) != 0) || /* Block incomming messages,
                                                    see _rel_disable() */
      (sigaddset(&sigact.sa_mask,SIGCHLD) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGTSTP) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGCONT) != 0))
    exit(-1);
  
  sigact.sa_handler = _ap_sig_child;
  sigact.sa_flags = SA_NOCLDSTOP;

  if(sigaction(SIGCHLD, &sigact, (struct sigaction *)0) < 0)
    exit(-1);
#endif

  /*
  * Initialization of communication Parameters and forwarding the obtained
  * information to the controlling process
  */

  cp_port = (u_short)atoi(argv[3]);
  
  cp_pid = (pid_t)atoi(argv[5]);
  
  if (_rel_d_setup(cp_hname,cp_port,cp_pid) < 0)
  {
    nx_perror("_rel_setup()");
    exit(-1);
  }

  /**
   ** Wait for SIGIOs to handle them
   **/
  _rel_wait_msg(term_daem);
  
  exit(0);
}



