/******************************************************************************
*
*    Buffer management for message ids
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  id_buffer.c,v
  1994/04/28 13:35:27
  1.5
  Exp
  plogstie
 
  Authors: Stefan Lamberts

  Description: Buffer management for message ids

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "id_buffer.c,v 1.5 1994/04/28 13:35:27 plogstie Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"


static buf_c_el *idt[ID_TAB_SIZE];
static id_list_el *free_ids;
static long max_id;



/*****************************************************************************/
int _init_i_buf
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  int i;

  for (i=0; i < ID_TAB_SIZE; i++)
    idt[i] = (buf_c_el *)0;

  free_ids = (id_list_el *)0;
  max_id = 0;

  return (0);
}

/*****************************************************************************/
long _dummy_msgid
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  return ((long)ID_TAB_SIZE);
}


/*****************************************************************************/
int _is_dummy_msgid
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{
  return (mid == (long)ID_TAB_SIZE);
}


/*****************************************************************************/
buf_c_el *_find_msgid
#ifdef ANSI
(long msg_id)
#else
(msg_id)
long msg_id;
#endif
/*****************************************************************************/
{
  /* LAMBO: The checks are necessary */
  if ((msg_id >= ID_TAB_SIZE) || (msg_id < 0))
  {
    errno = EINVAL;
    return ((buf_c_el *)0);
  }

  errno = 0;

  return (idt[msg_id]);
}

    
/*****************************************************************************/
long _ins_msgid
#ifdef ANSI
(buf_c_el *bce)
#else
(bce)
buf_c_el *bce;
#endif
/*****************************************************************************/
{
  id_list_el *el;
  long msg_id;

  if ((el = free_ids) != (id_list_el *)0)
  {
    msg_id = free_ids->msg_id;
    free_ids = free_ids->next;
    free((void *)el);
  }
  else if (max_id >= ID_TAB_SIZE)
  {
    errno = EQNOMID;
    return (-1);
  }
  else 
  {
    msg_id = max_id;
    max_id++;
  }

  if (idt[msg_id] != (buf_c_el *)0)
  {
    errno = ENXLBUF;                /* LAMBO: msg_id zweimal vergeben */
    return (-1);
  }

  idt[msg_id] = bce;
  
  bce->msg_id = msg_id;

  return (msg_id);
}

  

/*****************************************************************************/
int _free_msgid
#ifdef ANSI
(long msg_id)
#else
(msg_id)
long msg_id;
#endif
/*****************************************************************************/
{
  id_list_el *el;
  
  if (idt[msg_id] == (buf_c_el *)0)
  {
    errno = ENXLBUF;                /* LAMBO: Internal error */
    return (-1);
  }

  /* Free msd_id */
  idt[msg_id] = (buf_c_el *)0;

  if ((el = (id_list_el *)malloc(sizeof(id_list_el))) == (id_list_el *)0)
    return (-1);

  el->msg_id = msg_id;
  el->next = free_ids;
  free_ids = el;

  return (0);
}




/*****************************************************************************/
long _merge_msgid
#ifdef ANSI
(long msg_id_1, long msg_id_2)
#else
(msg_id_1, msg_id_2)
long msg_id_1;
long msg_id_2;
#endif
/*****************************************************************************/
{
  buf_c_el *el;
  buf_c_el *prev;
  
  /* Return the second message id if the first one is a dummy */
  if (_is_dummy_msgid(msg_id_1) &&
      (((msg_id_2 < ID_TAB_SIZE) &&
        (msg_id_2 >= 0) &&
        (idt[msg_id_2] != (buf_c_el *)0)) ||
       _is_dummy_msgid(msg_id_2)))
    return (msg_id_2);
  
  /* Return the first message id if the second one is a dummy */
  if (_is_dummy_msgid(msg_id_2) &&
      (msg_id_1 < ID_TAB_SIZE) &&
      (msg_id_1 >= 0) &&
      (idt[msg_id_1] != (buf_c_el *)0))
    return (msg_id_1);
  
  /* LAMBO: Checks necessary */
  if ((msg_id_1 >= ID_TAB_SIZE) ||
      ((msg_id_1 != -1) &&
       ((msg_id_1 < 0) || (idt[msg_id_1] == (buf_c_el *)0))) ||

      (msg_id_2 >= ID_TAB_SIZE) ||
      ((msg_id_2 != -1) &&
       ((msg_id_2 < 0) || (idt[msg_id_2] == (buf_c_el *)0))) ||
      
      ((msg_id_1 == -1) && (msg_id_2 == -1)))
  {
    errno = EQNOMID;
    return (-1);
  }

  if (msg_id_1 == -1)
    return (msg_id_2);

  if (msg_id_2 == -1)
    return (msg_id_1);

  for (prev = (buf_c_el *)0, el = idt[msg_id_2];
       el != (buf_c_el *)0;
       prev = el, el = el->id_next)
    el->msg_id = msg_id_1;
    
  prev->id_next = idt[msg_id_1];

  idt[msg_id_1] = idt[msg_id_2];

  if (_free_msgid(msg_id_2) < 0)
    return (-1);

  return (msg_id_1);
}

