/******************************************************************************
*
*    Receive messages in the buffer layer
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  buf_recv.c,v
  1995/02/13 10:28:17
  1.9
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Receive messages in the buffer layer

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "buf_recv.c,v 1.9 1995/02/13 10:28:17 lamberts Exp";
#endif

#include <errno.h>
#include <string.h>
#include <stdlib.h>

#ifdef SUN_OS4
#include <memory.h>
#endif

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern long      __myptype();
extern int       _confirm_msg();
extern buf_m_el *_create_msg();
extern int       _del_call();
extern buf_c_el *_find_rec_call();
extern int       _handle_hcalls();
extern int       _ins_hnd();
extern int       _ins_msg();
extern int       _rm_call();

/*****************************************************************************/
int _buf_recv
#ifdef ANSI
(int loc, msg_desc *msgd)
#else
(loc, msgd)
int loc;
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  buf_m_el *bme;

  /* Check wether there is a call waiting for a message of that type and source
   */

#ifdef BSVERBOSE
  _dbgmsg("BR N: %ld P: %ld T: %ld",
          msgd->s_node,
          msgd->s_ptype,
          msgd->msg_type);
#endif

  if ((bce = _find_rec_call(msgd->r_ptype,
                            msgd->msg_type,
                            msgd->s_node,
                            msgd->s_ptype,
                            CALL_PENDING)) != (buf_c_el *)0)
  {
    switch (bce->el_type)
    {
    case IRECVX:
    case HRECVX:

      if (msgd->r_ptype == __myptype())
      {
        if (_confirm_msg(msgd->s_node, msgd->s_ptype) < 0)
          return (-1);
        bce->status = CALL_DONE;
      }
      else
        bce->status = CALL_RECEIVED;

      /* Copy message in the appropriate buffer */
      bce->msg_type = msgd->msg_type;
      bce->s_node = msgd->s_node;
      bce->s_ptype = msgd->s_ptype;

      if (bce->count > msgd->msg_len)
      {
        bce->errno = EQMSGSHORT;
        if (msgd->msg_len > 0) 
          memcpy((void *)bce->buf,(void *)msgd->msg_ptr,(size_t)msgd->msg_len);
      }
      else if (bce->count < msgd->msg_len)
      {
        bce->errno = EQMSGLONG;
        if (bce->count > 0)
          memcpy((void *)bce->buf,(void *)msgd->msg_ptr,(size_t)bce->count);
      }
      else if (msgd->msg_len > 0)
        memcpy((void *)bce->buf,(void *)msgd->msg_ptr,(size_t)msgd->msg_len);
    
      /* If the message came from remote free the message buffer;
         it was allocated by lower layers */
      if ((loc == LOC_REMOTE) && (msgd->msg_len > 0))
        free((void *)msgd->msg_ptr);
      
      bce->msg_len = msgd->msg_len;
      
      if (bce->el_type == HRECVX)
      {
        if (_ins_hnd(bce) < 0)
          return (-1);

        if (_handle_hcalls() < 0)
          return (-1);
      }
      else if ((bce->status == CALL_DONE) && (bce->ignore == CALL_IGNORE))
      {
        if (_rm_call(bce) < 0)
          return (-1);
        if (_del_call(bce) < 0)
          return (-1);
      }
      
      return (0);
      
    default:
      errno = ENXLBUF;
      return (-1);
    }
  }          

  /* No pending call that matches was found */

  /*
   * Discard forced type messages.
   */
  if ((msgd->msg_type >= MAXSMT) && (msgd->msg_type < MAXFMT))
  {
    if ((loc == LOC_REMOTE) && (msgd->msg_len != 0))
      free((void *)msgd->msg_ptr);

    /* Confirm the message */
    if (_confirm_msg(msgd->s_node, msgd->s_ptype) < 0)
      return (-1);

    return (0);
  }
  
  /*
   * Enter  message in buffer for received messages.
   */
  if ((bme = _create_msg(loc, msgd)) == (buf_m_el *)0)
    return (-1);
    
  if (_ins_msg(bme) < 0)
    return (-1);

  /* Confirm the message */
  if (msgd->r_ptype == __myptype())
  {
    if (_confirm_msg(msgd->s_node, msgd->s_ptype) < 0)
      return (-1);
    bme->status = MSG_CONFIRMED;
  }

  
  return (0);
  
}
  


