/*****************************************************************************
*
*    Printing debugging messages
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
*****************************************************************************/
/******************************************************************************

  dbgmsg.c,v
  1995/02/06 15:31:55
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description:

     This file offers a procedure to print debugging messages with varargs

  Available functions from this module:

     void _dbgmsg("format",args...)

******************************************************************************/
#ifndef lint
static char rcs_id[] = "dbgmsg.c,v 1.6 1995/02/06 15:31:55 lamberts Exp";
#endif



#include <varargs.h>
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <malloc.h>

#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern long __myptype();
extern long __mynode();
extern char *ltoa();

/*****************************************************************************/
void _dbgmsg(va_alist)
va_dcl
/*****************************************************************************/
{
  long p;
  char *pt;
  va_list ap;
  char *form;
  char outp[200];
  
  va_start(ap);
  form = va_arg(ap, char *);
  
  switch ((p = __myptype()))
  {
  case CP_PTYPE:
    pt = "C";
    break;
  case DAEMON_PTYPE:
    pt = "D";
    break;
  default:
    if ((pt = ltoa(p)) == (char *)0)
      pt = "?";
    break;
  }

  vsprintf(outp, form, ap);
  fprintf(stdout,"(node %ld, ptype %s): %s\n",
          __mynode(),pt,outp);
  fflush(stdout);

  if ((p != CP_PTYPE) && (p != DAEMON_PTYPE))
    free((void *)pt);

  va_end(ap);
  
  return;
}

    
    
