/******************************************************************************
*
*    Forward certain signals fromthe controlling process to other processes
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  signal.c,v
  1996/10/16 15:18:58
  1.9
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Forward certain signals from the controlling process to
               other processes

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "signal.c,v 1.9 1996/10/16 15:18:58 lamberts Exp";
#endif

#include <errno.h>
#include <sys/types.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>

#include "../include/sys/nxlib.h"


extern long __numnodes();
extern int  _kill_aps();
extern int  _rel_send();
extern void nx_perror();

void _sig_cont();


/*****************************************************************************/
void _sig_tstp
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  long i;
  msg_cd_signal msg;
  int loc_errno = errno;

#ifdef BSD_SIG
  struct sigvec vec;
#else
  struct sigaction sigact;
#endif

  msg.signal = SIGTSTP;

  for (i=0; i < __numnodes(); i++)
  {
    if (_rel_send((long)CD_SIGNAL,
                   (char *)&msg,
                   (long)sizeof(msg_cd_signal),
                   i,
                   (long)DAEMON_PTYPE) < 0)
    {
      nx_perror("sig_tstp()");
      exit(-1);
    }
  }

  /* Setup the handler for SIGCONT */
#ifdef BSD_SIG
  vec.sv_handler = _sig_cont;
  vec.sv_mask = sigmask(SIGTSTP) |
    sigmask(SIGCONT) |
#ifdef ALRM_POLL
      sigmask(SIGALRM) |
#endif /* ALRM_POLL */
      sigmask(SIGIO) |
        sigmask(SIGCHLD);
  vec.sv_flags = 0;
  
  if (sigvec(SIGCONT, &vec, (struct sigvec *)0) != 0)
  {
    nx_perror("sig_tstp()");
    exit(-1);
  }
#else
  if ((sigemptyset(&sigact.sa_mask) != 0) ||
#ifdef ALRM_POLL
      (sigaddset(&sigact.sa_mask,SIGALRM) != 0) ||
#endif /* ALRM_POLL */
      (sigaddset(&sigact.sa_mask,SIGTSTP) != 0) || /* Block SIGTSTP */
      (sigaddset(&sigact.sa_mask,SIGCONT) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGIO) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGCHLD) != 0))
  {
    nx_perror("sig_tstp()");
    exit(-1);
  }

  sigact.sa_handler = _sig_cont;
  sigact.sa_flags = 0;

  if(sigaction(SIGCONT, &sigact, (struct sigaction *)0) < 0)
  {
    nx_perror("sig_tstp()");
    exit(-1);
  }
#endif
  
  /* Reset signal handler for SIGTSTP to default */
#ifdef BSD_SIG
  vec.sv_handler = SIG_DFL;
  vec.sv_flags = 0;
  vec.sv_mask = 0;
  
  if (sigvec(SIGTSTP, &vec, (struct sigvec *)0) != 0)
  {
    nx_perror("sig_tstp()");
    exit(-1);
  }
#else
  if ((sigemptyset(&sigact.sa_mask) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGTSTP) != 0))
  {
    nx_perror("sig_tstp()");
    exit(-1);
  }
  sigact.sa_handler = SIG_DFL;
  sigact.sa_flags = 0;
  if(sigaction(SIGTSTP, &sigact, (struct sigaction *)0) < 0)
  {
    nx_perror("sig_tstp()");
    exit(-1);
  }
#endif

  /* Send the signal to myself */
  if (kill(getpid(),SIGTSTP) < 0)
  {
    nx_perror("sig_tstp()");
    exit(-1);
  }

  errno = loc_errno;
  return;
}


/*****************************************************************************/
void _sig_cont
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  long i;
  msg_cd_signal msg;
  int loc_errno = errno;

#ifdef BSD_SIG
  struct sigvec vec;
#else
  struct sigaction sigact;
#endif

  msg.signal = SIGCONT;

  for (i=0; i < __numnodes(); i++)
  {
    if (_rel_send((long)CD_SIGNAL,
                   (char *)&msg,
                   (long)sizeof(msg_cd_signal),
                   i,
                   (long)DAEMON_PTYPE) < 0)
    {
      nx_perror("sig_cont()");
      exit(-1);
    }
  }

  /* Setup the handler for SIGTSTP */
#ifdef BSD_SIG
  vec.sv_handler = _sig_tstp;
  vec.sv_mask = sigmask(SIGCONT) |
    sigmask(SIGTSTP) |
#ifdef ALRM_POLL
      sigmask(SIGALRM) |
#endif /* ALRM_POLL */
      sigmask(SIGIO) |
        sigmask(SIGCHLD);
  vec.sv_flags = 0;
  
  if (sigvec(SIGTSTP, &vec, (struct sigvec *)0) != 0)
  {
    nx_perror("sig_cont()");
    exit(-1);
  }
#else    
  if ((sigemptyset(&sigact.sa_mask) != 0) ||
#ifdef ALRM_POLL
      (sigaddset(&sigact.sa_mask,SIGALRM) != 0) ||
#endif /* ALRM_POLL */
      (sigaddset(&sigact.sa_mask,SIGCONT) != 0) || /* Block SIGCONT */
      (sigaddset(&sigact.sa_mask,SIGTSTP) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGIO) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGCHLD) != 0))
  {
    nx_perror("sig_cont()");
    exit(-1);
  }

  sigact.sa_handler = _sig_tstp;
  sigact.sa_flags = 0;

  if(sigaction(SIGTSTP, &sigact, (struct sigaction *)0) < 0)
  {
    nx_perror("sig_cont()");
    exit(-1);
  }
#endif
  
  /* Reset signal handler for SIGCONT to default */
#ifdef BSD_SIG
  vec.sv_handler = SIG_DFL;
  vec.sv_mask = 0;
  vec.sv_flags = 0;

  if (sigvec(SIGCONT, &vec, (struct sigvec *)0) != 0)
  {
    nx_perror("sig_cont()");
    exit(-1);
  }
#else    
  if ((sigemptyset(&sigact.sa_mask) != 0) ||
      (sigaddset(&sigact.sa_mask,SIGCONT) != 0))
  {
    nx_perror("sig_cont()");
    exit(-1);
  }
  sigact.sa_handler = SIG_DFL;
  sigact.sa_flags = 0;
  if(sigaction(SIGCONT, &sigact, (struct sigaction *)0) < 0)
  {
    nx_perror("sig_cont()");
    exit(-1);
  }
#endif

  /* Send the signal to myself */
  if (kill(getpid(),SIGCONT) < 0)
  {
    nx_perror("sig_cont()");
    exit(-1);
  }

  errno = loc_errno;
  return;
}


/*****************************************************************************/
int _cd_signal
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/*****************************************************************************/
{
  msg_cd_signal *msg;

  msg = (msg_cd_signal *)msgd->msg_ptr;

  if (_kill_aps(msg->signal) < 0)
    return (-1);

  return (0);
}





