/******************************************************************************
*
*    Wait for the arrival of messages
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  rel_wait_msg.c,v
  1996/10/16 15:18:26
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Wait for the arrival of messages as long as a condition is 
               not zero.

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "rel_wait_msg.c,v 1.6 1996/10/16 15:18:26 lamberts Exp";
#endif

#include <signal.h>

/*****************************************************************************/
void _rel_wait_msg
#ifdef ANSI
(int (*cond)(void));
#else
(cond)
int (*cond)();
/*****************************************************************************/
#endif
{
#ifdef BSD_SIG
  int oldmask;

  oldmask = sigblock(sigmask(SIGIO) |
#ifdef ALRM_POLL
                     sigmask(SIGALRM) |
#endif /* ALRM_POLL */
                     sigmask(SIGCHLD) |
                     sigmask(SIGTSTP) |
                     sigmask(SIGCONT));
  while(cond())
    sigpause(0);
  sigsetmask(oldmask);
#else
  sigset_t set;
  sigset_t oset;

  /* Block all signals to check the condition */
  sigemptyset(&set);
#ifdef ALRM_POLL
  sigaddset(&set,SIGALRM);
#endif /* ALRM_POLL */
  sigaddset(&set,SIGIO);
  sigaddset(&set,SIGCHLD);
  sigaddset(&set,SIGTSTP);
  sigaddset(&set,SIGCONT);
  
  sigprocmask(SIG_SETMASK,&set,&oset);

  sigemptyset(&set);
  while(cond())
    sigsuspend(&set);

  sigprocmask(SIG_SETMASK,&oset,(sigset_t *)0);
#endif
}

  
