/******************************************************************************
*
*    Send a message reliably to anotyher process
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  rel_send.c,v
  1995/02/21 14:19:59
  1.9
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Send a message reliably to anotyher process

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "rel_send.c,v 1.9 1995/02/21 14:19:59 lamberts Exp";
#endif

#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>

#ifdef SUN_OS4
#include <memory.h>             /* Should be included in string.h */
#endif

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __mynode();
extern long      __myptype();
extern int       _aa_confirm();
extern int       _buf_recv();
extern p_listel *_find_plistel();
extern int       _get_addr();
extern int       _rem_open_conn();
extern int       _rem_send();
extern int       _set_addr_plistel();



/*****************************************************************************/
static int _rel_rem_send
#ifdef ANSI
(msg_desc *msg, p_listel *plel)
#else
(msg, plel)
msg_desc *msg;
p_listel *plel;
#endif
/*****************************************************************************/
{
  rem_addr radr;

  radr.sockfd = plel->radr.sockfd;
  radr.stat = 0;
  memcpy((void *)&(radr.sad),
         (void *)&(plel->radr.sad),
         sizeof(struct sockaddr_in));
  
  if (radr.sockfd == UNDEF_SOCK) 
  {
    if ((radr.sockfd = _rem_open_conn(&radr.sad)) < 0)
      return (-1);
    radr.stat = ADDR_UNKNOWN;
    if (_set_addr_plistel(plel->node,
                          plel->ptypes.ptype,
                          LOC_UNDEF,
                          &radr,
                          (loc_addr *)0,
                          (char *)0,
                          (char *)0,
                          (char *)0,
                          UNDEF_PID) < 0)
      return (-1);
  }
  if (_rem_send(radr.sockfd,msg) < 0)
    return (-1);
  
  return (0);
}


static int _rel_loc_send
#ifdef ANSI
(msg_desc *msg, p_listel *plel)
#else
(msg, plel)
msg_desc *msg;
p_listel *plel;
#endif
{
  errno = ENOSYS;
  return(-1);
}




/*****************************************************************************/
int _rel_send
#ifdef ANSI
(long type, char *msg_buff, long count, long node, long ptype)
#else
(type, msg_buff, count, node, ptype)
long type;
char *msg_buff;
long count;
long node;
long ptype;
#endif
/*****************************************************************************/
{
  msg_desc msg;
  p_listel *plel;

  if ((plel = _find_plistel(node, ptype)) == (p_listel *)0)
  {
    errno = ENXLAUK;
    return (-1);
  }
  if ((plel->radr.sockfd == UNDEF_SOCK) && (plel->radr.stat != ADDR_SET)) 
  {
    errno = ENXLANS;
    return (-1);
  }
  
    
  msg.msg_ptr = msg_buff;
  msg.msg_len = count;
  msg.msg_type = type;
  msg.s_ptype = __myptype(); 
  msg.s_node = __mynode();   
  msg.s_pid = getpid();
  msg.r_ptype = ptype;
  msg.r_node = node;
  
  
  switch (plel->loc) 
  {
  case LOC_UNDEF:
    errno = ENOSYS;
    return (-1);
  case LOC_REMOTE:
    return (_rel_rem_send(&msg,plel));
  case LOC_LOCAL:
    return (_rel_loc_send(&msg,plel));
  case LOC_MYSELF:
    switch (msg.msg_type)
    {
    case AA_CONFIRM:
      return(_aa_confirm(&msg));
    default:
      if (((msg.msg_type >= 0) && (msg.msg_type < MAXUMT)) ||
          ((msg.msg_type >= MAXSMT) && (msg.msg_type < MAXFMT)))
        return (_buf_recv(LOC_MYSELF,&msg));
      else
      {
        errno =  EBADMSG;
        return (-1);
      }
    }
  }
  
  errno = ENOSYS;
  return (-1);
}
