/******************************************************************************
*
*    Setup the reliable communication layer for application processes
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  rel_a_setup.c,v
  1995/02/06 16:12:00
  1.7
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Setup the reliable communication layer for application processes

  Available functions from this module:

******************************************************************************/
#ifndef lint
static char rcs_id[] = "rel_a_setup.c,v 1.7 1995/02/06 16:12:00 lamberts Exp";
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef SUN_OS4
#include <memory.h>             /* Should be included in string.h */
#endif

#include "../include/sys/nxlib.h"

extern long      __mynode();
extern long      __myptype();
extern int       _a_handler();
extern int       _init_plist();
extern int       _ins_plistel();
extern int       _rel_send();
extern rem_addr *_rem_setup();

#ifdef LOCAL_COMM
extern loc_addr *_loc_setup();
#endif



/*****************************************************************************/
int _rel_a_setup
#ifdef ANSI
(u_short port)
#else
(port)
u_short port;
#endif
/*****************************************************************************/
{
  rem_addr adr;
  rem_addr *myradr = (rem_addr *)0;
#ifdef LOCAL_COMM
  loc_addr *myladr = (loc_addr *)0;
#endif
  char hostname[MAXHNAMELEN];
  struct hostent *hp;
  msg_ad_addappl msg;
#ifndef BSD_SIG
  sigset_t set;
#endif

  _rel_disable();

  if (_init_plist() < 0)
  {
    _rel_enable();
    return (-1);
  }

  if ((myradr = _rem_setup(_a_handler)) == (rem_addr *)0)
  {
    _rel_enable();
    return (-1);
  }

#ifdef LOCAL_COMM
  if ((myladr = _loc_setup(_a_handler)) == (loc_addr *)0)
  {
    _rel_enable();
    return (-1);
  }
#endif

  if (gethostname(hostname, MAXHNAMELEN) < 0 ) 
  {
    _rel_enable();
    return (-1);
  }

  /**
   ** Enter address information about this process in this address database
   **/
  if (_ins_plistel(__mynode(),
                   __myptype(),
                   LOC_MYSELF,
                   myradr,
                   (loc_addr *)0,
                   hostname,
                   getlogin(),
                   (char *)0,
                   getpid(),
                   (long)UNDEF_NODE,
                   (long)UNDEF_PTYPE) < 0)
  {
    _rel_enable();
    return (-1);
  }


  /***
   *** Insert the address of the daemon process into the
   *** address database
   ***/
    
  if ((hp = gethostbyname(hostname)) == (struct hostent *)0)
  {
    _rel_enable();
    return (-1);
  }
  adr.sockfd = UNDEF_SOCK;
  adr.stat = ADDR_SET;
  memset((void *)&adr.sad, (int)0, sizeof(struct sockaddr_in));
  adr.sad.sin_family = hp->h_addrtype;
  memcpy((void *)&adr.sad.sin_addr, (void *)hp->h_addr, (size_t)hp->h_length);
  adr.sad.sin_port = port;

  if (_ins_plistel(__mynode(),
                   (long)DAEMON_PTYPE,
                   LOC_REMOTE,
                   &adr,
                   (loc_addr *)0,
                   hostname,
                   getlogin(),
                   (char *)0,
                   getppid(),
                   (long)UNDEF_NODE,
                   (long)UNDEF_PTYPE) < 0)
  {
    _rel_enable();
    return (-1);
  }

  /** Send a message to the daemon process in order to inform it about the
   ** pid of this application process and its socket address
   **/
  msg.node = __mynode();
  msg.ptype = __myptype();
  msg.radr.sockfd = UNDEF_SOCK;
  msg.radr.stat = ADDR_SET;
  memcpy((void *)&msg.radr.sad,
         (void *)&myradr->sad,
         sizeof(struct sockaddr_in));

  if (_rel_send((long)AD_ADDAPPL,
                (char *)&msg,
                (long)sizeof(msg_ad_addappl),
                __mynode(),
                (long)DAEMON_PTYPE) < 0)
  {
    _rel_enable();
    return(-1);
  }

  _rel_enable();

  /* Reset the signal mask which might block some signals because it is
     inherited from the parent process */
#ifdef BSD_SIG
  sigsetmask(0);
#else
  if (sigemptyset(&set) != 0)
    return (-1);
  if (sigprocmask(SIG_SETMASK, &set, (sigset_t *)0) != 0)
    return (-1);
#endif

  return (0);
}

