/******************************************************************************
*
*    Handler for incomming messgages for application processes
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  a_handler.c,v
  1994/12/30 16:33:52
  1.8
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Handler for incomming messgages for application processes

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "a_handler.c,v 1.8 1994/12/30 16:33:52 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"
#include "../include/nxmalloc.h"

extern int _a_flushmsg();
extern int _aa_confirm();
extern int _buf_recv();
extern int _da_ackptype();
extern int _da_addr_repl();
extern int _da_apexit();
extern int _da_gfunct();
extern int _da_pidnr();


/***************************************************************************/
int _a_handler
#ifdef ANSI
(msg_desc *msgd)
#else
(msgd)
msg_desc *msgd;
#endif
/**************************************************************************/
{
  int res;
  int free_msg = 1;
  
  if (msgd == (msg_desc *)0) 
  {
    errno = EINVAL;
    return (-1);
  }
  
  switch (msgd->msg_type)
  {
  case DA_ACKPTYPE:             /* DP->AP Acknowledgement for setptype() */
    res = _da_ackptype(msgd);
    break;
  
  case ADDR_REPL:               /* DP->AP Address answer */
    res = _da_addr_repl(msgd);
    break;
  
  case DA_APEXIT:               /* DP->AP Loaded process terminated */
    res = _da_apexit(msgd);
    break;
  
  case DA_PIDNR:                /* DP->AP Pid of loaded process */
    res = _da_pidnr(msgd);
    break;
    
  case AA_CONFIRM:              /* AP->AP Confirmation of a message */
    res = _aa_confirm(msgd);
    break;
  
  case DA_GFUNCT:               /* DP->AP forward of the data of a global
                                   function*/
    res = _da_gfunct(msgd);
    break;
  
  case FLUSHMSG:
    res = _a_flushmsg(msgd);
    break;
    
  default:                      /* normal message from the user */
    if (((msgd->msg_type >= 0) && (msgd->msg_type < MAXUMT)) ||
        ((msgd->msg_type >= MAXSMT) && (msgd->msg_type < MAXFMT)))
    {
      res = _buf_recv(LOC_REMOTE,msgd);
      free_msg = 0;
    }
    else
    {
      errno =  EBADMSG;
      res = -1;
    }
    break;
  }
  
  if ((free_msg == 1) && (msgd->msg_len != 0))
    free((void *)msgd->msg_ptr);
  free((void *)msgd);

  return (res);
}

