/******************************************************************************
*
*    Set ptype functions for the daemon
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  ptype_d.c,v
  1993/10/19 16:42:31
  1.3
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Set ptype functions for the daemon

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "ptype_d.c,v 1.3 1993/10/19 16:42:31 lamberts Exp";
#endif

#include "../include/sys/nxlib.h"

extern int _add_ptype_plistel();
extern int _rel_send();


/************************************************************************
 * If a process changes its process type back to a previous value, or
 * to a new ptype which is not already in use accept ptype;
 * If it is a new ptype for a process insert this process in the own table
 * with the new ptype;
 * else don't assign the new ptype to the process
 * Send a message back to the caller with a negative/positive request
 ************************************************************************/
int
#ifdef ANSI
_ad_setptype(msg_desc *msgd)
#else
_ad_setptype(msgd)
msg_desc *msgd;
#endif
/************************************************************************/
{
  int setptype_ok;
  msg_ad_setptype *msg;
  msg_da_ackptype msgo;
  
  msg = (msg_ad_setptype *)msgd->msg_ptr;
  
  /* if a  process changes its process type back to a previous value, or
   * to a new ptype which is not already in use accept ptype
   * else don't assign the new ptype to the process
   */  
  if ((setptype_ok = _add_ptype_plistel(msg->node,msg->ptype,msg->pid)) < 0)
    return (-1);

  msgo.setptype_ok = setptype_ok;
  
  if (_rel_send((long)DA_ACKPTYPE,
                (char *)&msgo,
                (long)sizeof(msg_da_ackptype),
                msgd->s_node,
                msgd->s_ptype) < 0)
    return (-1);
  
  return (setptype_ok);
}
