/******************************************************************************
*
*    Probe for a message
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  probe.c,v
  1994/01/19 10:31:17
  1.3
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Probe for a message

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "probe.c,v 1.3 1994/01/19 10:31:17 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long      __myptype();
extern long      __numnodes();
extern buf_m_el *_find_msg();
extern void      _rel_disable();
extern void      _rel_enable();
extern void      _rel_wait_msg();
extern void      nx_perror();

extern long msginfo[];

static long cp_typesel;
static long cp_nodesel;
static long cp_ptypesel;
static long *cp_info;
static int cp_errno;


/*****************************************************************************/
long _iprobex
#ifdef ANSI
(long typesel, long nodesel, long ptypesel, long *info)
#else
(typesel, nodesel, ptypesel, info)
long typesel;
long nodesel;
long ptypesel;
long *info;
#endif
/*****************************************************************************/
{
  buf_m_el *bme;

  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if (((typesel != -1) && (typesel < 0)) || 
      ((typesel >= MAXUMT) && (typesel < MAXSMT)) ||
      (typesel >= MAXFMT)) 
  {
    errno = EQTYPE;
    return (-1);
  }

  if (((nodesel != -1) && (nodesel < 0)) ||
      (nodesel > __numnodes()))
  {
    errno = EQNODE;
    return (-1);
  }

  if (((ptypesel != -1) && (ptypesel < 0)) ||
      (ptypesel > MAXPTYPE))
  {
    errno = EQPID;
    return (-1);
  }

  /* Disable incomming messages to avoid races */
  _rel_disable();
  
  if ((bme = _find_msg(typesel, nodesel, ptypesel)) == (buf_m_el *)0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (0);
  }
  

  if (info != (long *)0)
  {
    info[0] = bme->msg_type;
    info[1] = bme->msg_len;
    info[2] = bme->s_node;
    info[3] = bme->s_ptype;
  }
    
  /* Enable incomming messages */
  _rel_enable();
    
  return (1);
}




/*****************************************************************************/
long iprobex
#ifdef ANSI
(long typesel, long nodesel, long ptypesel, long *info)
#else
(typesel, nodesel, ptypesel, info)
long typesel;
long nodesel;
long ptypesel;
long *info;
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _iprobex(typesel, nodesel, ptypesel, info)) < 0)
  {
    nx_perror("iprobex()");
    exit(-1);
  }

  return (res);
}



/*****************************************************************************/
long _iprobe
#ifdef ANSI
(long typesel)
#else
(typesel)
long typesel;
#endif
/*****************************************************************************/
{
  return (_iprobex(typesel,(long) -1,(long) -1, msginfo));
}



/*****************************************************************************/
long iprobe
#ifdef ANSI
(long typesel)
#else
(typesel)
long typesel;
#endif
/*****************************************************************************/
{
  long res;
  
  if ((res = _iprobe(typesel)) < 0)
  {
    nx_perror("iprobe()");
    exit(-1);
  }

  return (res);
}





/*****************************************************************************/
static int cprobe_done
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _iprobex(cp_typesel, cp_nodesel, cp_ptypesel, cp_info)) < 0)
  {
    cp_errno = errno;
    return (1);
  }
  return (res == 0); 
}


/*****************************************************************************/
long _cprobex
#ifdef ANSI
(long typesel, long nodesel, long ptypesel, long *info)
#else
(typesel, nodesel, ptypesel, info)
long typesel;
long nodesel;
long ptypesel;
long *info;
#endif
/*****************************************************************************/
{
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if (((typesel !=-1) && (typesel < 0)) || 
      ((typesel >= MAXUMT) && (typesel < MAXSMT)) ||
      (typesel >= MAXFMT)) 
  {
    errno = EQTYPE;
    return (-1);
  }

  if (((nodesel != -1) && (nodesel < 0)) ||
      (nodesel > __numnodes()))
  {
    errno = EQNODE;
    return (-1);
  }

  if (((ptypesel != -1) && (ptypesel < 0)) ||
      (ptypesel > MAXPTYPE))
  {
    errno = EQPID;
    return (-1);
  }

  cp_typesel = typesel;
  cp_nodesel = nodesel;
  cp_ptypesel = ptypesel;
  cp_info = info;
  cp_errno = 0;

  _rel_wait_msg(cprobe_done);
  
  if (cp_errno != 0)
  {
    errno = cp_errno;
    return (-1);
  }
  
  return (0);
}




/*****************************************************************************/
void cprobex
#ifdef ANSI
(long typesel, long nodesel, long ptypesel, long *info)
#else
(typesel, nodesel, ptypesel, info)
long typesel;
long nodesel;
long ptypesel;
long *info;
#endif
/*****************************************************************************/
{
  if (_cprobex(typesel, nodesel, ptypesel, info) < 0)
  {
    nx_perror("cprobex()");
    exit(-1);
  }

  return;
}



/*****************************************************************************/
long _cprobe
#ifdef ANSI
(long typesel)
#else
(typesel)
long typesel;
#endif
/*****************************************************************************/
{
  return (_cprobex(typesel, (long)-1, (long)-1, msginfo));
}



/*****************************************************************************/
void cprobe
#ifdef ANSI
(long typesel)
#else
(typesel)
long typesel;
#endif
/*****************************************************************************/
{
  if (_cprobe(typesel) < 0)
  {
    nx_perror("cprobe()");
    exit(-1);
  }

  return;
}




