/******************************************************************************
*
*    Functions needed by the daemon during initalization
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nxinit_d.c,v
  1995/02/21 14:21:51
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts, Susanna Schink

  Description:
  This file contains the procedure which is needed for nx_initve() on the
  daemons side. That is the procedure to receive the CD_INITDLIST message.

  Available functions from this module:

  void _cd_initdlist(msg)
  msg_desc *msg;

******************************************************************************/
#ifndef lint
static char rcs_id[] = "nxinit_d.c,v 1.6 1995/02/21 14:21:51 lamberts Exp";
#endif

#include <stdlib.h>

#include "../include/sys/nxlib.h"

extern long __mynode();
extern long __numnodes();
extern int _update_plistel();


/**************************************************************************
 * Obtain the address information about the other daemon processes from the
 * controlling process and store the values in the own table for later
 * requests
 *************************************************************************/
int
#ifdef ANSI
_cd_initd(msg_desc *msgd)
#else
_cd_initd(msgd)
msg_desc *msgd;
#endif
/*************************************************************************/
{
  long numnd;
  msg_cd_initd *msg;
  long i;
  
  msg = (msg_cd_initd *)msgd->msg_ptr;
  
  numnd = __numnodes();

  
  for (i = 0; i < numnd; i++) 
    if (msg[i].node != __mynode())
      if (_update_plistel(msg[i].node,
                          (long)DAEMON_PTYPE,
                          LOC_REMOTE, /* LAMBO: Das ist nicht immer so. */
                          &msg[i].radr,
                          (loc_addr *)0,
                          msg[i].hname,
                          msg[i].login,
                          msg[i].arch,
                          UNDEF_PID,
                          (long)UNDEF_NODE,
                          (long)UNDEF_PTYPE) < 0)
        return (-1);
  
  if (_rel_send((long)DC_INITDONE,
                (char *)0,
                (long)0,
                __myhost(),
                (long)CP_PTYPE) < 0)
    return (-1);

  return (0);
}
