/******************************************************************************
*
*    Functions for the number of all nodes
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  numnodes.c,v
  1994/01/19 10:58:03
  1.4
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Functions for the number of all nodes

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "numnodes.c,v 1.4 1994/01/19 10:58:03 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"

extern void nx_perror();


static long numnds = -1;




/*************************************************************************
 * Sets the static variable numnds.
 * This procedure can be called only once successfully
 ************************************************************************/
void __setnumnodes
#ifdef ANSI
(long val)
#else
(val)
long val;
#endif
/************************************************************************/
{
  static int not_called = 1;
  
  if (not_called)
  {
    numnds = val;
    not_called = 0;
  }
  return;
}


 
/*************************************************************************
 * Returns the value of numnds withour error checking
 ************************************************************************/
long
#ifdef ANSI
__myhost(void)
#else
__myhost()
#endif
/************************************************************************/
{
  return (numnds);
}

/*************************************************************************
 * Gets the node number of the controlling process
 * - upon successful completion, returns the node number of the CP
 * - otherwise, returns -1 and indicates the error
 ************************************************************************/
long
#ifdef ANSI
_myhost(void)
#else
_myhost()
#endif
/************************************************************************/
{
  if (numnds < 0)
  {
    errno = EQNODE;
    return (-1);
  }
  return (numnds);
}

/*************************************************************************
 * Gets the node number of the controlling process
 * - upon successful completion, returns the node number of the CP, and
 *   returns control to the calling process
 * - otherwise, displays an error message to stderr. and causes the calling
 *   process to terminate 
 ************************************************************************/
long
#ifdef ANSI
myhost(void)
#else
myhost()
#endif
/************************************************************************/
{
  long res;

  if ((res = _myhost()) < 0)
  {
    nx_perror("myhost()");
    exit(-1);
  }

  return(res);
}



/*************************************************************************
 * Returns the value of numnds without error checking
 ************************************************************************/
long __numnodes
#ifdef ANSI
(void)
#else
()
#endif
/************************************************************************/
{
  return (numnds);
}



/*************************************************************************
 * Gets the number of nodes in an application
 * - upon successful completion, returns the number of nodes in an appli-
 *   cation
 * - otherwise, returns -1 and indicates the error
 ************************************************************************/
long _numnodes
#ifdef ANSI
(void)
#else
()
#endif
/************************************************************************/
{
  if (numnds < 0)
  {
    errno = EQNODE;
    return (-1);
  }
  return (numnds);
}


/*************************************************************************
 * Gets the number of nodes in an application
 * - upon successful completion, returns the number of nodes in an
 *   application, and returns control to the calling process
 * - otherwise, displays an error message to stderr. and causes the calling
 *   process to terminate
 ************************************************************************/
long numnodes
#ifdef ANSI
(void)
#else
()
#endif
/************************************************************************/
{
  long res;

  if ((res = _numnodes()) < 0)
  {
    nx_perror("numnodes()");
    exit(-1);
  }

  return(res);
}

