/******************************************************************************
*
*    Functions for this node's nodesnumber
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  mynode.c,v
  1994/01/19 10:58:01
  1.4
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Functions for this node's nodesnumber

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "mynode.c,v 1.4 1994/01/19 10:58:01 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"

extern void nx_perror();

static long node = -1;



/*************************************************************************
 * Set set node variable.
 * This procedure can be called only once sucessfully.
 ************************************************************************/
void
#ifdef ANSI
__setnode(long val)
#else
__setnode(val)
long val;
#endif
/************************************************************************/
{
  static int not_called = 1;
  
  if (not_called)
  {
    node = val;
    not_called = 0;
  }
  return;
}



/*************************************************************************
 * Return the value of node without error checking
 ************************************************************************/
long
#ifdef ANSI
__mynode(void)
#else
__mynode()
#endif
/************************************************************************/
{
  return(node);
}

  
/*************************************************************************
 * Gets the node number of the calling process
 * - upon successful completion, returns the node number of the caller
 * - otherwise, returns -1 and indicate the error
 ************************************************************************/
long
#ifdef ANSI
_mynode(void)
#else
_mynode()
#endif
/************************************************************************/
{
  if (node < 0) {
    errno = EQNODE;
    return (-1);
  }
  return(node);
}

/*************************************************************************
 * Gets the node number of the calling process
 * - upon successful completion, returns the node number of the caller,
 *   and returns control to the caller
 * - otherwise, displays an error message to stderr. and causes the caller
 *   to terminate
 ************************************************************************/
long
#ifdef ANSI
mynode(void)
#else
mynode()
#endif
/************************************************************************/
{
  long res;

  if ((res = _mynode()) < 0)
  {
    nx_perror("mynode()");
    exit(-1);
  }

  return(res);
}

