/******************************************************************************
*
*    msg....() calls
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  msg.c,v
  1995/02/14 07:39:30
  1.5
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: msg....() calls

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "msg.c,v 1.5 1995/02/14 07:39:30 lamberts Exp";
#endif

#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long       __myptype();
extern int       _del_call();
extern buf_c_el *_find_msgid();
extern int       _free_msgid();
extern int       _is_dummy_msgid();
extern long      _merge_msgid();
extern void      _rel_disable();
extern void      _rel_enable();
extern void      _rel_wait_msg();
extern int       _rm_call();
extern void      nx_perror();

static int mw_errno;
static long mw_mid;



/*****************************************************************************/
long _msgcancel
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  buf_c_el *next;
  
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if (_is_dummy_msgid(mid))     /* If mid is the dummy message id
                                 * do nothing */
    return (0);

  /* Disable incomming messages to avoid races */
  _rel_disable();

  if ((bce = _find_msgid(mid)) == (buf_c_el *)0)
  {
    errno = EQMID;

    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }

  if (_free_msgid(mid) < 0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }

  for (;bce != (buf_c_el *)0; bce = next)
  {
    next = bce->id_next;
    if (_rm_call(bce) < 0)
    {
      /* Enable incomming messages */
      _rel_enable();
      
      return (-1);
    }
    if (_del_call(bce) < 0)
    {
      /* Enable incomming messages */
      _rel_enable();
    
      return (-1);
    }
    
  }

  /* Enable incomming messages */
  _rel_enable();
    
  return (0);
}


/*****************************************************************************/
void msgcancel
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{
  if (_msgcancel(mid) < 0)
  {
    nx_perror("msgcancel()");
    exit(-1);
  }

  return;
}




/*****************************************************************************/
long _msgdone
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  buf_c_el *ptr;
  buf_c_el *next;
  
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if (_is_dummy_msgid(mid))     /* If mid is the dummy message id
                                 * do nothing */
    return (1);

  /* Disable incomming messages to avoid races */
  _rel_disable();
  
  if ((bce = _find_msgid(mid)) == (buf_c_el *)0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    errno = EQMID;
    return (-1);
  }

  for (ptr = bce; ptr != (buf_c_el *)0; ptr = ptr->id_next)
    if (ptr->status != CALL_DONE)
    {
      /* Enable incomming messgages */
      _rel_enable();
      
      return (0);
    }

  /* All calls are done.
   * Remove them. */
  
  if (_free_msgid(mid) < 0)
  {
    /* Enable incomming messgages */
    _rel_enable();
    
    return (-1);
  }

  for(ptr = bce; ptr != (buf_c_el *)0; ptr = next)
  {
    next = ptr->id_next;

    /* Set msginfo */
    if ((ptr->el_type == IRECVX) && (ptr->info != (long *)0))
    {
      ptr->info[0] = ptr->msg_type;
      ptr->info[1] = ptr->msg_len;
      ptr->info[2] = ptr->s_node;
      ptr->info[3] = ptr->s_ptype;
    }

    if (_rm_call(ptr) < 0)
    {
      /* Enable incomming messages */
      _rel_enable();
    
      return (-1);
    }
    if (_del_call(ptr) < 0)
    {
      /* Enable incomming messages */
      _rel_enable();
      
      return (-1);
    }
  }

  /* Enable incomming messages */
  _rel_enable();
    
  return (1);
}
  


/*****************************************************************************/
long msgdone
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _msgdone(mid)) < 0)
  {
    nx_perror("msgdone()");
    exit(-1);
  }

  return (res);
}


/*****************************************************************************/
long _msgignore
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{
  buf_c_el *bce;
  buf_c_el *ptr;
  buf_c_el *next;
  
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if (_is_dummy_msgid(mid))     /* If mid is the dummy message id
                                 * do nothing */
    return (0);

  /* Disable incomming messages to avoid races */
  _rel_disable();
  
  if ((bce = _find_msgid(mid)) == (buf_c_el *)0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    errno = EQMID;
    return (-1);
  }
  
  if (_free_msgid(mid) < 0)
  {
    /* Enable incomming messages */
    _rel_enable();
    
    return (-1);
  }

  for (ptr = bce; ptr != (buf_c_el *)0; ptr = next)
  {
    next = ptr->id_next;

    if (ptr->status == CALL_DONE)
    {
      if (_rm_call(ptr) < 0)
      {
        /* Enable incomming messages */
        _rel_enable();   
        
        return (-1);
      }
      if (_del_call(ptr) < 0)
      {
        /* Enable incomming messages */
        _rel_enable();
        
        return (-1);
      }
    }
    else
      ptr->ignore = CALL_IGNORE;
  }
  
  /* Enable incomming messages */
  _rel_enable();
    
  return (0);
}

  

/*****************************************************************************/
void msgignore
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{
  if (_msgignore(mid) < 0)
  {
    nx_perror("msgignore()");
    exit(-1);
  }

  return;
}




/*****************************************************************************/
long _msgmerge
#ifdef ANSI
(long mid1, long mid2)
#else
(mid1, mid2)
long mid1;
long mid2;
#endif
/*****************************************************************************/
{
  long res;
  
  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  /* Disable incomming messages to avoid races */
  _rel_disable();
  
  res =_merge_msgid(mid1,mid2);
  
  /* Enable incomming messages */
  _rel_enable();

  return (res);
}



/*****************************************************************************/
long msgmerge
#ifdef ANSI
(long mid1, long mid2)
#else
(mid1, mid2)
long mid1;
long mid2;
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _msgmerge(mid1,mid2)) < 0)
  {
    nx_perror("msgmerge()");
    exit(-1);
  }

  return (res);
}



/*****************************************************************************/
static int msgwait_done
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _msgdone(mw_mid)) < 0)
  {
    mw_errno = errno;
    return (1);
  }
  return (res == 0); 
}


/*****************************************************************************/
long _msgwait
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{

  if (__myptype() < 0)
  {
    errno = EQNOSET;
    return (-1);
  }

  if (_is_dummy_msgid(mid))     /* If mid is the dummy message id
                                 * do nothing */
    return (0);

  /* Disable incomming messages to avoid races */
  _rel_disable();

  if (_find_msgid(mid) == (buf_c_el *)0)
  {
    /* Enable incomming messages */
    _rel_enable();

    errno = EQMID;
    return (-1);
  }
  
  /* Enable incomming messages */
  _rel_enable();

  mw_errno = 0;
  mw_mid = mid;

  _rel_wait_msg(msgwait_done);
  
  if (mw_errno != 0)
  {
    errno = mw_errno;
    return (-1);
  }
  
  return (0);
}

/*****************************************************************************/
void msgwait
#ifdef ANSI
(long mid)
#else
(mid)
long mid;
#endif
/*****************************************************************************/
{
  if (_msgwait(mid) < 0)
  {
    nx_perror("msgwait()");
    exit(-1);
  }

  return;
}

