/******************************************************************************
*
*    Global calls
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  gcalls.c,v
  1994/12/30 16:30:59
  1.5
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Global calls

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "gcalls.c,v 1.5 1994/12/30 16:30:59 lamberts Exp";
#endif


#include <errno.h>
#include <stdlib.h>

#include "../include/sys/nxerrno.h"
#include "../include/sys/nxlib.h"

extern long __mynode();
extern long __myptype();
extern long __numnodes();
extern long __gdhigh();
extern long __gdlow();
extern long __gdprod();
extern long __gdsum();
extern long __giand();
extern long __gihigh();
extern long __gilow();
extern long __gior();
extern long __giprod();
extern long __gisum();
extern long __gland();
extern long __glor();
extern long __gshigh();
extern long __gslow();
extern long __gsprod();
extern long __gssum();
extern long _gfunct();
extern void nx_perror();



/*****************************************************************************/
long _gcol
#ifdef ANSI
(char *x, long xlen, char *y, long ylen, long *ncnt)
#else
(x, xlen, y, ylen, ncnt)
char *x;
long xlen;
char *y;
long ylen;
long *ncnt;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GCOL, sizeof(char),
                  x, xlen, y, ylen, ncnt,
                  (long (*)())0));
}

          
/*****************************************************************************/
void gcol
#ifdef ANSI
(char *x, long xlen, char *y, long ylen, long *ncnt)
#else
(x, xlen, y, ylen, ncnt)
char *x;
long xlen;
char *y;
long ylen;
long *ncnt;
#endif
/*****************************************************************************/
{
  if (_gcol(x, xlen, y, ylen, ncnt) < 0)
  {
    nx_perror("gcol()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _gcolx
#ifdef ANSI
(char *x, long *xlens, char *y)
#else
(x, xlens, y)
char *x;
long *xlens;
char *y;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GCOLX,sizeof(char),
                  x, xlens[__mynode()], y,
                  (long)0,
                  xlens,
                  (long (*)())0));
}

          
/*****************************************************************************/
void gcolx
#ifdef ANSI
(char *x, long *xlen, char *y)
#else
(x, xlen, y)
char *x;
long *xlen;
char *y;
#endif
/*****************************************************************************/
{
  if (_gcolx(x,xlen,y) < 0)
  {
    nx_perror("gcolx()");
    exit(-1);
  }
  return;
}




/*****************************************************************************/
long _gdhigh
#ifdef ANSI
(double *x, long xlen, double *work)
#else
(x, xlen, work)
double *x;
long xlen;
double *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GDHIGH,sizeof(double),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gdhigh));
}

          
/*****************************************************************************/
void gdhigh
#ifdef ANSI
(double *x, long xlen, double *work)
#else
(x, xlen, work)
double *x;
long xlen;
double *work;
#endif
/*****************************************************************************/
{
  if (_gdhigh(x, xlen, work) < 0)
  {
    nx_perror("gdhigh()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _gihigh
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GIHIGH,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gihigh));
}

          
/*****************************************************************************/
void gihigh
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if (_gihigh(x, xlen, work) < 0)
  {
    nx_perror("gihigh()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _gshigh
#ifdef ANSI
(float *x, long xlen, float *work)
#else
(x, xlen, work)
float *x;
long xlen;
float *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GSHIGH,sizeof(float),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gshigh));
}

          
/*****************************************************************************/
void gshigh
#ifdef ANSI
(float *x, long xlen, float *work)
#else
(x, xlen, work)
float *x;
long xlen;
float *work;
#endif
/*****************************************************************************/
{
  if (_gshigh(x, xlen, work) < 0)
  {
    nx_perror("gshigh()");
    exit(-1);
  }
  return;
}





/*****************************************************************************/
long _gdlow
#ifdef ANSI
(double *x, long xlen, double *work)
#else
(x, xlen, work)
double *x;
long xlen;
double *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GDLOW,sizeof(double),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gdlow));
}

          
/*****************************************************************************/
void gdlow
#ifdef ANSI
(double *x, long xlen, double *work)
#else
(x, xlen, work)
double *x;
long xlen;
double *work;
#endif
/*****************************************************************************/
{
  if (_gdlow(x, xlen, work) < 0)
  {
    nx_perror("gdlow()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _gilow
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GILOW,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gilow));
}

          
/*****************************************************************************/
void gilow
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if (_gilow(x, xlen, work) < 0)
  {
    nx_perror("gilow()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _gslow
#ifdef ANSI
(float *x, long xlen, float *work)
#else
(x, xlen, work)
float *x;
long xlen;
float *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GSLOW,sizeof(float),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gslow));
}

          
/*****************************************************************************/
void gslow
#ifdef ANSI
(float *x, long xlen, float *work)
#else
(x, xlen, work)
float *x;
long xlen;
float *work;
#endif
/*****************************************************************************/
{
  if (_gslow(x, xlen, work) < 0)
  {
    nx_perror("gslow()");
    exit(-1);
  }
  return;
}






/*****************************************************************************/
long _gdprod
#ifdef ANSI
(double *x, long xlen, double *work)
#else
(x, xlen, work)
double *x;
long xlen;
double *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GDPROD,sizeof(double),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gdprod));
}

          
/*****************************************************************************/
void gdprod
#ifdef ANSI
(double *x, long xlen, double *work)
#else
(x, xlen, work)
double *x;
long xlen;
double *work;
#endif
/*****************************************************************************/
{
  if (_gdprod(x, xlen, work) < 0)
  {
    nx_perror("gdprod()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _giprod
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GIPROD,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __giprod));
}

          
/*****************************************************************************/
void giprod
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if (_giprod(x, xlen, work) < 0)
  {
    nx_perror("giprod()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _gsprod
#ifdef ANSI
(float *x, long xlen, float *work)
#else
(x, xlen, work)
float *x;
long xlen;
float *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GSPROD,sizeof(float),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gsprod));
}

          
/*****************************************************************************/
void gsprod
#ifdef ANSI
(float *x, long xlen, float *work)
#else
(x, xlen, work)
float *x;
long xlen;
float *work;
#endif
/*****************************************************************************/
{
  if (_gsprod(x, xlen, work) < 0)
  {
    nx_perror("gsprod()");
    exit(-1);
  }
  return;
}




/*****************************************************************************/
long _gdsum
#ifdef ANSI
(double *x, long xlen, double *work)
#else
(x, xlen, work)
double *x;
long xlen;
double *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GDSUM,sizeof(double),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gdsum));
}

          
/*****************************************************************************/
void gdsum
#ifdef ANSI
(double *x, long xlen, double *work)
#else
(x, xlen, work)
double *x;
long xlen;
double *work;
#endif
/*****************************************************************************/
{
  if (_gdsum(x, xlen, work) < 0)
  {
    nx_perror("gdsum()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _gisum
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GISUM,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gisum));
}

          
/*****************************************************************************/
void gisum
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if (_gisum(x, xlen, work) < 0)
  {
    nx_perror("gisum()");
    exit(-1);
  }
  return;
}



/*****************************************************************************/
long _gssum
#ifdef ANSI
(float *x, long xlen, float *work)
#else
(x, xlen, work)
float *x;
long xlen;
float *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GSSUM,sizeof(float),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gssum));
}

          
/*****************************************************************************/
void gssum
#ifdef ANSI
(float *x, long xlen, float *work)
#else
(x, xlen, work)
float *x;
long xlen;
float *work;
#endif
/*****************************************************************************/
{
  if (_gssum(x, xlen, work) < 0)
  {
    nx_perror("gssum()");
    exit(-1);
  }
  return;
}




/*****************************************************************************/
long _giand
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GIAND,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __giand));
}

          
/*****************************************************************************/
void giand
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if (_giand(x, xlen, work) < 0)
  {
    nx_perror("giand()");
    exit(-1);
  }
  return;
}







/*****************************************************************************/
long _gland
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GLAND,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gland));
}

          
/*****************************************************************************/
void gland
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if (_gland(x, xlen, work) < 0)
  {
    nx_perror("gland()");
    exit(-1);
  }
  return;
}






/*****************************************************************************/
long _gior
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GIOR,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __gior));
}

          
/*****************************************************************************/
void gior
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if (_gior(x, xlen, work) < 0)
  {
    nx_perror("gior()");
    exit(-1);
  }
  return;
}




/*****************************************************************************/
long _glor
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GLOR,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  __glor));
}

          
/*****************************************************************************/
void glor
#ifdef ANSI
(long *x, long xlen, long *work)
#else
(x, xlen, work)
long *x;
long xlen;
long *work;
#endif
/*****************************************************************************/
{
  if (_glor(x, xlen, work) < 0)
  {
    nx_perror("glor()");
    exit(-1);
  }
  return;
}





/*****************************************************************************/
long _gopf
#ifdef ANSI
(char *x, long xlen, char *work, long (*function)())
#else
(x, xlen, work, function)
char *x;
long xlen;
char *work;
long (*function)();
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GOPF,sizeof(long),
                  (char *)x,xlen,(char *)work,
                  (long)0,(long *)0,
                  function));
}

          
/*****************************************************************************/
void gopf
#ifdef ANSI
(char *x, long xlen, char *work, long (*function)())
#else
(x, xlen, work, function)
char *x;
long xlen;
char *work;
long (*function)();
#endif
/*****************************************************************************/
{
  if (_gopf(x, xlen, work, function) < 0)
  {
    nx_perror("gopf()");
    exit(-1);
  }
  return;
}


/*****************************************************************************/
long _gsync
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  if ((__mynode() >= __numnodes()) || (__mynode() < 0))
  {
    errno = EQNODE;
    return (-1);
  }
  
  if ((__myptype() < 0) || (__myptype() > MAXPTYPE))
  {
    errno = EQNOSET;
    return (-1);
  }
  
  return (_gfunct(GSYNC,
                  (unsigned)0,
                  (char *)0,(long)0,
                  (char *)0,(long)0,(long *)0,
                  (long (*)())0));
}

          
/*****************************************************************************/
void gsync
#ifdef ANSI
(void)
#else
()
#endif
/*****************************************************************************/
{
  if (_gsync() < 0)
  {
    nx_perror("gsync()");
    exit(-1);
  }
  return;
}



