/******************************************************************************
*
*    Synchronous send calls
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  csend.c,v
  1994/01/19 10:57:45
  1.3
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Synchronous send calls

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "csend.c,v 1.3 1994/01/19 10:57:45 lamberts Exp";
#endif

#include <stdlib.h>

extern long __myptype();
extern long _isend();
extern long _isendrecv();
extern long _msgmerge();
extern long _msgwait();
extern long infocount();
extern void nx_perror();


/*****************************************************************************/
long _csend
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype)
#else
(type, buf, count, node, ptype)
long type;
char *buf;
long count;
long node;
long ptype;
#endif
/*****************************************************************************/
{
  long msg_id;

  if ((msg_id = _isend(type, buf, count, node, ptype)) < 0)
    return (-1);

  if (_msgwait(msg_id) < 0)
    return (-1);
  
  return (0);
}

    
/*****************************************************************************/
void csend
#ifdef ANSI
(long type, char *buf, long count, long node, long ptype)
#else
(type, buf, count, node, ptype)
long type;
char *buf;
long count;
long node;
long ptype;
#endif
/*****************************************************************************/
{
  if (_csend(type, buf, count, node, ptype) < 0)
  {
    nx_perror("csend()");
    exit(-1);
  }

  return;
}



/*****************************************************************************/
long _csendrecv
#ifdef ANSI
(long type, char *sbuf, long scount, long node, long ptype,
 long typesel, char *rbuf, long rcount)
#else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount)
long type;
char *sbuf;
long scount;
long node;
long ptype;
long typesel;
char *rbuf;
long rcount;
#endif
/*****************************************************************************/
{
  long msg_id;

  if ((msg_id = _isendrecv(type, sbuf, scount, node, ptype,
                           typesel, rbuf, rcount)) < 0)
    return (-1);

  if (_msgwait(msg_id) < 0)
    return (-1);

  return (infocount());
}


/*****************************************************************************/
long csendrecv
#ifdef ANSI
(long type, char *sbuf, long scount, long node, long ptype,
 long typesel, char *rbuf, long rcount)
#else
(type, sbuf, scount, node, ptype, typesel, rbuf, rcount)
long type;
char *sbuf;
long scount;
long node;
long ptype;
long typesel;
char *rbuf;
long rcount;
#endif
/*****************************************************************************/
{
  long res;

  if ((res = _csendrecv(type, sbuf, scount, node, ptype, typesel, rbuf, rcount))
      < 0)
  {
    nx_perror("csendrecv()");
    exit(-1);
  }

  return (res);
}

  


/*****************************************************************************/
long _gsendx
#ifdef ANSI
(long type, char *buf, long count, long *node, long nodecount)
#else
(type, buf, count, node, nodecount)
long type;
char *buf;
long count;
long *node;
long nodecount;
#endif
/*****************************************************************************/
{
  long msg_id;
  long n_msg_id;
  long i;

  msg_id = -1;

  for (i = 0; i < nodecount; i++)
  {
    if ((n_msg_id = _isend(type, buf, count, node[i], __myptype())) < 0)
      return (-1);

    if ((msg_id = _msgmerge(msg_id,n_msg_id)) < 0)
      return (-1);
  }

  if (_msgwait(msg_id) < 0)
    return (-1);

  return (0);
}


    

/*****************************************************************************/
void gsendx
#ifdef ANSI
(long type, char *buf, long count, long *node, long nodecount)
#else
(type, buf, count, node, nodecount)
long type;
char *buf;
long count;
long *node;
long nodecount;
#endif
/*****************************************************************************/
{
  if (_gsendx(type, buf, count, node, nodecount) < 0)
  {
    nx_perror("gsendx()");
    exit(-1);
  }

  return;
}
