/******************************************************************************
*
*    Synchronous receive calls
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  crecv.c,v
  1994/01/19 10:57:41
  1.3
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description: Synchronous receive calls

  Available functions from this module: ....

******************************************************************************/
#ifndef lint
static char rcs_id[] = "crecv.c,v 1.3 1994/01/19 10:57:41 lamberts Exp";
#endif

#include <stdlib.h>

extern long _irecvx();
extern long _msgwait();
extern void nx_perror();

extern long msginfo[];


/*****************************************************************************/
long _crecvx
#ifdef ANSI
(long typesel, char *buf, long count, long nodesel, long ptypesel, long *info)
#else
(typesel, buf, count, nodesel, ptypesel, info)
long typesel;
char *buf;
long count;
long nodesel;
long ptypesel;
long *info;
#endif
/*****************************************************************************/
{
  long msg_id;

  if ((msg_id = _irecvx(typesel, buf, count, nodesel, ptypesel, info)) < 0)
    return (-1);

  if (_msgwait(msg_id) < 0)
    return (-1);
  
  return (0);
}


/*****************************************************************************/
void crecvx
#ifdef ANSI
(long typesel, char *buf, long count, long nodesel, long ptypesel, long *info)
#else
(typesel, buf, count, nodesel, ptypesel, info)
long typesel;
char *buf;
long count;
long nodesel;
long ptypesel;
long *info;
#endif
/*****************************************************************************/
{
  if (_crecvx(typesel, buf, count, nodesel, ptypesel, info) < 0)
  {
    nx_perror("crecvx()");
    exit(-1);
  }

  return;
}



/*****************************************************************************/
long _crecv
#ifdef ANSI
(long typesel, char *buf, long count)
#else
(typesel, buf, count)
long typesel;
char *buf;
long count;
#endif
/*****************************************************************************/
{
  return (_crecvx(typesel, buf, count, (long)-1, (long)-1, msginfo));
}



/*****************************************************************************/
void crecv
#ifdef ANSI
(long typesel, char *buf, long count)
#else
(typesel, buf, count)
long typesel;
char *buf;
long count;
#endif
/*****************************************************************************/
{
  if (_crecv(typesel, buf, count) < 0)
  {
    nx_perror("crecv()");
    exit(-1);
  }

  return;
}


