/******************************************************************************
*
*    nxlib.h header file
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nxlib.h,v
  1995/02/21 14:21:41
  1.12
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description:  Available functions from this module:

******************************************************************************/


#ifndef __sys_nxlib_h
#define __sys_nxlib_h

#ifndef lint
static char rcs_id_sys_nxlib_h[] = "nxlib.h,v 1.12 1995/02/21 14:21:41 lamberts Exp";
#endif

#include <sys/types.h>
#include <netinet/in.h>

/*
 * Default Partition name
 */
#define DEFAULT_PART_NAME  ".compute"

/*
 * NX Environment variables
 */
#define NX_DFLT_PART  "NX_DFLT_PART"
#define NX_DFLT_SIZE  "NX_DFLT_SIZE"
#define NXLIBPATH     "NXLIBPATH"

/*
 * rsh commandline option
 */
#define RSHOPTION  "-n"

/* 
 * Length of host name, architecture specification and login name
 */
#define MAXHNAMELEN  256        /* RFC952 RFC1132 */
#ifndef MAXPATHLEN
#define MAXPATHLEN   256
#endif
#define MAXARCHLEN   20
#define MAXLOGINLEN  9


/*
* ptype for the local daemons and for the controlling process
*/
#define UNDEF_PTYPE   -1
#define DAEMON_PTYPE  -2
#define CP_PTYPE      -3
#define MAXPTYPE      2147483647

/*
 * Message type constants
 */
#define MAXUMT 1000000000       /* Maximal type of user messages */
#define MAXSMT 1073741824       /* Maximal type of system messages */
#define MAXFMT 2000000000       /* Maximal type of force messages */



/**
 ** Types needed for the process database
 **/


/* Element of the list of ptypes */
typedef struct PTYPE_EL
{
  struct PTYPE_EL *next;
  long ptype;
} ptype_el;



/*
 * State of address information (possible values of stat)
 */
#define ADDR_UNKNOWN  0
#define ADDR_KNOWN    1
#define ADDR_SET      2

/* 
 * Socket descriptor
 */
#define UNDEF_SOCK  -1

/* Remote address information */
typedef struct 
{
  int sockfd;                   /* socket file descriptor */
  int stat;                     /* state of the address
                                 * ADDR_UNKNOWN
                                 * ADDR_KNOWN
                                 * ADDR_SET */
  struct sockaddr_in sad;       /* address information */
} rem_addr;


/* Local address information */
typedef int loc_addr;           /* This is not used yet */


/*
 * Location definitions (values of loc)
 */
#define LOC_UNDEF   0
#define LOC_LOCAL   1
#define LOC_REMOTE  2
#define LOC_MYSELF  3

/*
 * State of a process (values of stat)
 */
#define PROC_RUNN  0
#define PROC_DEAD  1

/*
 * Return values of _add_ptype_plistel()
 */
#define PT_OK  0                /* Ptype was set */
#define PT_EX  1                /* Ptype is occupied by another process */
#define PT_NE  2                /* There is no matching process */

/*
 * Unix pid
 */
#define UNDEF_PID  -1

/*
 * Nodenumber
 */
#define UNDEF_NODE  -1

/* Element of the list of process information */
typedef struct P_LISTEL {
  struct P_LISTEL *next;        /* Next element */
  ptype_el  ptypes;             /* List of ptypes */

  long      node;               /* Node number */
  int       loc;                /* Location of the process */
  pid_t     pid;                /* UNIX process Id */
  int       stat;               /* Status of the process */
  long      l_node;             /* Node number of the process which loaded
                                   that process */
  long      l_ptype;            /* Ptpye of the process which loaded
                                   that process */

  rem_addr  radr;               /* Remote address information */
  loc_addr  ladr;               /* Local address information */

  char      hname[MAXHNAMELEN]; /* Hostname */
  char      login[MAXLOGINLEN]; /* Login name */
  char      arch[MAXARCHLEN];   /* Architectur */
} p_listel;




/* Element of the list of unanswered address requests */
typedef struct REQ_EL
{
  struct REQ_EL *next;
  struct REQ_EL *prev;

  long rt_node;                 /* Nodenumber of the process to which the reply
                                   shall be send*/
  long rt_ptype;                /* Ptype of the process to which the reply
                                   shall be send */
  long f_node;                  /* Nodenumber of the requesting process */
  long f_ptype;                 /* Ptype of the requesting process */
  long r_node;                  /* Nodenumber of the procces who's address
                                   is needed */
  long r_ptype;                 /* Ptype of the process who's address is
                                   needed */
} req_el;




/**
 ** Types needed for the specification of VPNs
 **/


/* Paragon VPN specification */
typedef struct VPN_SPEC
{
  struct VPN_SPEC *next;        /* Next element */

  long node;
  char hname[MAXHNAMELEN];      /* Hostname */
  char path[MAXPATHLEN];        /* Path */
  char login[MAXLOGINLEN];      /* Login */
  char arch[MAXARCHLEN];        /* Architecture specification */
} vpn_spec;


/**
 ** Types needed for the reliable communication layer and below
 **/

/* message descriptor */
typedef struct msg_desc
{
  char  *msg_ptr;               /* Pointer auf den Inhalt */
  long  msg_len;                /* Laenge des Inhalts */
  long  msg_type;               /* Typ der Nachricht */
  long  s_ptype;                /* ptype des Absenders */
  long  s_node;                 /* Node des Absenders */
  long  r_ptype;                /* ptype des Empfaengers */
  long  r_node;                 /* Node des Empfaengers */
  pid_t s_pid;                  /* pid of sender */
} msg_desc;



/**
 ** Types needed for the buffer layer
 **/

/*
 * State of messages (values of status)
 */
#define MSG_UNCONFIRMED 0
#define MSG_CONFIRMED 1


/* Element of a received message buffer */
typedef struct BUF_M_EL
{
  struct BUF_M_EL *pt_next;     /* Next element with the same ptype */
  struct BUF_M_EL *pt_prev;     /* Previous element with the same ptype */
  struct BUF_M_EL *mt_next;     /* Next element with the same mtype */
  struct BUF_M_EL *mt_prev;     /* Previous element with the same mtype */

  char  *msg_ptr;               /* Pointer to message buffer */
  long  msg_len;                /* Length of message  */
  long  msg_type;               /* Type of Message */
  long  s_node;                 /* Ptype of Sender */
  long  s_ptype;                /* Nodenumber of sender */
  long  r_node;                 /* Nodenumber of receiver */
  long  r_ptype;                /* Ptype of receiver */

  int   location;               /* Location where the message came from */
  int   status;                 /* Message confirmed flag */
} buf_m_el;


/* Element of the Message type table */
typedef struct MT_TAB_EL
{
  buf_m_el  *first;             /* Pointer to the first element of the list */
  buf_m_el  *last;              /* Pointer to the last element of the list */
  struct MT_TAB_EL *bucket;     /* Pointer to the hash buckets */

  long      msg_type;           /* Type of the messages */
} mt_tab_el;

/*
 * Size of message hash table
 */
#define MT_TAB_SIZE 100


/* Element of the ptype table for messages */
typedef struct PT_TAB_M_EL
{
  buf_m_el   *first;            /* First element of the received messages */
  buf_m_el   *last;             /* Last element of the received messages */
  mt_tab_el  *mt_tab[MT_TAB_SIZE]; /* Message type hash table */
  struct PT_TAB_M_EL *bucket;

  long       ptype;             /* Ptype */
} pt_tab_m_el;

/*
 * Size of ptype hash table for messages
 */
#define PT_TAB_M_SIZE 100


/*
 * Types of calls (values of el_type)
 */
#define IRECVX  0
#define HRECVX  1
#define ISEND   2
#define HSENDX  3

/*
 * States of calls (values of status)
 */
#define CALL_PENDING   0
#define CALL_RECEIVED  1
#define CALL_SENT      2
#define CALL_DONE      3

/*
 * Ignore result of call (values of ignore)
 */
#define CALL_IGNORE    0
#define CALL_NOIGNORE  1

/* Information of pending recv or probe calls */
typedef struct BUF_C_EL
{
  int   el_type;                /* Type of element
                                   IRECVX || CPROBEX || HRECVX || ISEND */
  long  msg_id;                 /* Message Id of this element */
  int   status;                 /* Status of this element */
  int   ignore;                 /* Message confirmed flag */
  int   errno;                  /* Number of an occurred error */

  long  msg_type;               /* Type of the message */
  long  s_node;                 /* Nodenumber of the sender */
  long  s_ptype;                /* Ptype of the sender */
  long  r_node;                 /* Nodenumber of the receiver */
  long  r_ptype;                /* Ptype of the receiver */

  char  *buf;                   /* Pointer to the message buffer */
  long  msg_len;                /* Length of message */
  long  count;                  /* Length of buffer */

  long  *info;
  void  (*handler)();           /* Pointer to the handler function */
  long  hparam;                 /* handler Parameter */

  struct BUF_C_EL *pt_next;     /* Pointer to the next call with the same
                                   ptype */
  struct BUF_C_EL *pt_prev;     /* Pointer to the previous call with the same
                                   ptype */
  struct BUF_C_EL *id_next;     /* Poniter to the next call with the same
                                   msgid */
  struct BUF_C_EL *h_next;      /* Pointer to the next call that needs to be
                                   handled (needed for masktrap) */
  struct BUF_C_EL *h_prev;      /* Pointer to the previous call that needs to
                                   be handled (needed for masktrap) */
} buf_c_el;

/* Element of the ptype table for calls */
typedef struct PT_TAB_C_EL
{
  buf_c_el  *first;             /* First element of the pending calls */
  buf_c_el  *last;              /* Last element of the pending calls */
  struct PT_TAB_C_EL *bucket;

  long      ptype;              /* Ptype */
} pt_tab_c_el;

/*
 * Size of ptype hash table for calls
 */
#define PT_TAB_C_SIZE  100

/*
 * Message id
 */
#define UNDEF_MSGID  -1

/* Element of list of free message ids */
typedef struct ID_LIST_EL
{
  struct ID_LIST_EL *next;

  long  msg_id;
} id_list_el;

/*
 * Size of msg id table
 */
#define ID_TAB_SIZE  10000



/**
 ** types for global calls
 **/


/*
 * Types of global functions (values of gtype)
 */

#define GCOL     0              /* gcol() */
#define GCOLX    1              /* gcolx() */
#define GDHIGH   2              /* gdhigh() */
#define GIHIGH   3              /* gihigh() */
#define GSHIGH   4              /* gshigh() */
#define GDLOW    5              /* gdlow() */
#define GILOW    6              /* gilow() */
#define GSLOW    7              /* gslow() */
#define GDPROD   8              /* gdprod() */
#define GIPROD   9              /* giprod() */
#define GSPROD  10              /* gsprod() */
#define GDSUM   11              /* gdsum() */
#define GISUM   12              /* gisum() */
#define GSSUM   13              /* gssum() */
#define GIAND   14              /* gland() */
#define GLAND   15              /* giand() */
#define GIOR    16              /* gior() */
#define GLOR    17              /* glor() */
#define GOPF    18              /* gopf() */
#define GSYNC   19              /* gsync() */

/* Data for a global call of different length (gcol()) */
typedef struct
{
  char  *data;                  /* Data */
  long  len;                    /* Number of bytes */
} gc_var_dat;

/* information about a global function call */
typedef struct GC_EL
{
  struct GC_EL *next;           /* Pointer to next global function */
  struct GC_EL *prev;           /* Pointer to previous global function */

  char  *rmsg;                  /* Pointer to the answer message */
  char  *data;                  /* Data */
  gc_var_dat *vardata;          /* Data entries of different length */

  long  ptype;                  /* Ptype of the processes */
  int   gtype;                  /* Type of global call */
  long  done;                   /* Number of processed messages */
  long  xlen;                   /* Length of one data item */
  long  ylen;                   /* Length of the concatenation (gcol[x]()) */
} gc_list_el;




/**
 ** Administration messages
 **/

/* Address information of a nxdaemon */
#define DC_ADDNXD  MAXUMT+1     /* DP->CP: add me to list */
typedef struct
{
  long      node;               /* Nodenumber */
  rem_addr  radr;               /* Remote address */
  loc_addr  ladr;               /* Local address */
}  msg_dc_addnxd;

/* Information needed to initialize the nxdaemons */
#define CD_INITD  MAXUMT+2  /* CP->DP: init Daemon */
typedef struct
{
  long      node;               /* Nodenumber */
  rem_addr  radr;               /* Remote address */
  loc_addr  ladr;               /* Local address */
  char      hname[MAXHNAMELEN]; /* Hostname */
  char      login[MAXLOGINLEN]; /* Login */
  char      arch[MAXARCHLEN];   /* Architecture specification */
} msg_cd_initd;


/* nx_loadve() information for the nxdaemons */
#define AD_LOADAPPL  MAXUMT+10  /* AP->DP: load/start Appl.Proc. */
typedef  struct 
{
  long  l_node;                 /* Loading node */
  long  l_ptype;                /* Loading ptype */
  long  node;                   /* Node */
  long  ptype;                  /* Ptype */
  int   argc;                   /* Number of arguments */
  int   envc;                   /* Number of environment variables */
  long  naidx;                  /* Index of na */
} msg_ad_loadappl;

/* Address information of an application process */
#define AD_ADDAPPL  MAXUMT+11   /* AP->DP: add me to your Appl. List */
typedef struct
{
  long      node;               /* Node number */
  long      ptype;              /* Ptype */
  rem_addr  radr;               /* Remote address */
  loc_addr  ladr;               /* Local address */
} msg_ad_addappl;

/* pid of loaded process */
#define DA_PIDNR  MAXUMT+12     /* DP->AP: pid number of my applic. process */
typedef  struct
{
  long  l_node;                 /* Loading node */
  long  l_ptype;                /* Loading ptype */
  long  node;                   /* Node */
  pid_t pid;                    /* Pid */
  long  naidx;                  /* Index of na */
} msg_da_pidnr;

/* Information about the termination of a loaded process  */
#define DA_APEXIT  MAXUMT+13    /* DP->DP: delete Appl. from your List */
typedef  struct
{
  long  l_node;                 /* Loading node */
  long  l_ptype;                /* Loading ptype */
  long  node;                   /* Nodenumber */
  pid_t pid;                    /* Pid */
  int   status;                 /* Exitstatus */
} msg_da_apexit;


/* Request from an application process to set a ptype */
#define AD_SETPTYPE  MAXUMT+20  /* AP->DP: set my ptype to a new_ptype */
typedef struct
{
  pid_t pid;                    /* Pid */
  long  node;                   /* Nodenumber */
  long  ptype;                  /* New ptype */
} msg_ad_setptype;

/* Acknowledgement of a setptype() request */
#define DA_ACKPTYPE  MAXUMT+21  /* DP->AP: acknowledge/not  new_ptype */
typedef struct
{
  int  setptype_ok;             /* setptype is ok or not */
} msg_da_ackptype;


/* Address request  */
#define ADDR_REQ  MAXUMT+30  /* Address request */
typedef struct
{
  long  rt_node;                /* Nodenumber of the process to which the reply
                                   shall be send*/
  long  rt_ptype;               /* Ptype of the process to which the reply
                                   shall be send */
  long  f_node;                 /* Nodenumber of the requesting process */
  long  f_ptype;                /* Ptype of the requesting process */
  long  r_node;                 /* Nodenumber of the procces who's address
                                   is needed */
  long  r_ptype;                /* Ptype of the process who's address is
                                   needed */
} msg_addr_req;

/* Reply to a address request */
#define ADDR_REPL  MAXUMT+31  /* Address request */
typedef struct
{
  long      f_node;             /* Nodenumber of the requesting process */
  long      f_ptype;            /* Ptype of th requesting process */
  long      r_node;             /* Nodenumber of the address */
  long      r_ptype;            /* Ptype of the address */
  pid_t     pid;                /* Pid of the address */
  rem_addr  radr;               /* Remote address */
  loc_addr  ladr;               /* Local address */
  char      hname[MAXHNAMELEN]; /* Hostname of the address */
  char      login[MAXLOGINLEN]; /* Login of the address */
  char      arch[MAXARCHLEN];   /* Architectur specification of the address */
} msg_addr_repl;


/* Close a double socket connection between two processes */
#define DOUBLE_CONN  MAXUMT+35  /* Close double connection */


/* global function request */
#define  AD_GFUNCT  MAXUMT+40
#define  DC_GFUNCT  MAXUMT+41
typedef struct 
{
  long  node;
  long  ptype;
  int   gtype;
  long  xlen;
  long  offs;
  long  ylen;
} msg_ac_gfunct;

/* global function answer */
#define  CD_GFUNCT  MAXUMT+42
#define  DA_GFUNCT  MAXUMT+43
typedef struct
{
  long  ptype;
  int   gtype;
  long  ylen;
} msg_ca_gfunct;


/* signal forward */
#define CD_SIGNAL  MAXUMT+50    /* CP->DP: send the spec. signal to appl's */ 
typedef struct
{
  int  signal;
} msg_cd_signal;


/* Confirmation of the reception of a message
 * This is needed to make sure that the receiving process has the right ptype
 */
#define AA_CONFIRM  MAXUMT+60   /* AP->AP Confirm Message */
typedef struct
{
  long  s_ptype;                /* Ptype of the sender */
  long  r_node;                 /* Node of the receiver */
  long  r_ptype;                /* Ptype of the receiver */
} msg_aa_confirm;


/* flushmsg */
#define FLUSHMSG  MAXUMT+70
typedef struct
{
  long  f_node;                 /* Flushing node */
  pid_t   f_pid;                  /* Flushing pid */
  long  node;                   /* Node to be flushed */
  long  ptype;                  /* Ptype to be flushed */
  long  type;                   /* Message type to flush */
} msg_flushmsg;

/* This daemon received the initialization */
#define DC_INITDONE MAXUMT+71

/* XPARAGON */

#define XP_PORT 3999            /* Portnumber of XPARAGON */

#define XP_SEND 1               /* Protocol type for a send call */
#define XP_LOAD 2               /* Protocol type for the load of a node */

#define XP_PROT  MAXUMT+80
typedef struct
{
  int   type;                   /* Type of the portocol (XP_SEND || XP_LOAD) */
  long  par1;                   /* Sending node for send protocols
                                   Node for load protocols */
  long  par2;                   /* Receiving node for send protocols
                                   Loadvalue for load protocols */
} msg_xp_prot;



#endif /* __sys_nxlib_h */
