/******************************************************************************
*
*    nxerrno.h header file
*    Copyright (C) 1993 A. Bode, S. Lamberts, T. Ludwig, G. Stellner
*
*    This file is part of NXLIB (Paragon(TM) message passing on workstations)
*
*    NXLIB is free software; you can redistribute it and/or
*    modify it under the terms of the GNU Library General Public
*    License as published by the Free Software Foundation; either
*    version 2 of the License, or (at your option) any later version.
*
*    NXLIB is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*    Library General Public License for more details.
*
*    You should have received a copy of the GNU Library General Public
*    License along with this library; if not, write to the Free
*    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*    Contact to the authors:
*
*    electronic mail: nxlib@informatik.tu-muenchen.de
*
*    paper mail:      Prof. Dr. A. Bode
*                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                     Institut f"ur Informatik
*                     Technische Universit"at M"unchen
*                     80290 M"unchen
*                     Germany
*
*    Paragon(TM) is a trademark of Intel Corporation.
*
******************************************************************************/
/******************************************************************************

  nxerrno.h,v
  1995/02/21 14:19:47
  1.6
  Exp
  lamberts
 
  Authors: Stefan Lamberts

  Description:  Defintions of error number macros.

******************************************************************************/

#ifndef __sys_nx_errno_h

#define __sys_nx_errno_h

#ifndef lint
static char rcs_id_sys_nxerrno_h[] = "nxerrno.h,v 1.6 1995/02/21 14:19:47 lamberts Exp";
#endif


/***
 *** Macros for PARAGON specific error numbers
 ***/

/* Partition Management Error Codes */
#define F_PMERR 10000               /* Offset of PARGON partition management
                                     * error numbers.
                                     * Must be greater that the highest
                                     * error number in the standard errno.h
                                     * file.
                                     */
#define EPALLOCERR   (F_PMERR+0)    /* allocator internal error */
#define EPXRS        (F_PMERR+1)    /* exceeds partition resources */
#define EPBADNODE    (F_PMERR+2)    /* bad node specification */
#define EPINVALPART  (F_PMERR+3)    /* partition not found */
#define EPINVALPRI   (F_PMERR+4)    /* invalid priority */
#define EPNOTEMPTY   (F_PMERR+5)    /* partition not empty */
#define EPINVALMOD   (F_PMERR+6)    /* invalid mode */
#define EPPARTEXIST  (F_PMERR+7)    /* partition exists */
#define EPINVALSCHED (F_PMERR+8)    /* invalid scheduling */
#define EPACCES      (F_PMERR+9)    /* partition permission denied */
#define ERFORK       (F_PMERR+10)   /* do a rfork instead of a fork */
#define EAINVALPKT   (F_PMERR+20)   /* packet size invalid or out of range */
#define EAINVALMBF   (F_PMERR+21)   /* memory buffer invalid or out of range */
#define EAINVALMEX   (F_PMERR+22)   /* memory export invalid or out of range */
#define EAINVALMEA   (F_PMERR+23)   /* memory each invalid or out of range */
#define EAINVALSTH   (F_PMERR+24)   /* send threshold invalid or out of
                                       range */
#define EAINVALSCT   (F_PMERR+25)   /* send count invalid or out of range */
#define EAINVALGTH   (F_PMERR+26)   /* give threshold invalid or out of
                                       range */
#define EANOTPGL     (F_PMERR+27)   /* calling process not process group
                                       leader */
#define EAEXIST      (F_PMERR+28)   /* application exists for process group */
#define EPINUSER     (F_PMERR+29)   /* Invalid User */
#define EPINGRP      (F_PMERR+30)   /* Invalid group */
#define EPINRN       (F_PMERR+31)   /* Invalid partition rename */
#define EPLOCK       (F_PMERR+32)   /* Partition lock denied */
#define EPBXRS       (F_PMERR+33)   /* partition request contains bad/missing
                                       nodes */
#define EANOEXIST    (F_PMERR+34)   /* application does not exist for process
                                       group */
#define EINTERNAL    (F_PMERR+35)   /* Miscellaneous internal error */




/* nx call errors */
#define F_NXERR    (F_PMERR+100)    /* Offset of PARGON nx call error numbers. 
                                     */
#define EQPBUF     (F_NXERR+0)      /* Invalid buffer pointer */
#define EQBLEN     (F_NXERR+1)      /* Buffer length exceeds allocation */
#define EQLEN      (F_NXERR+2)      /* Invalid length */
#define EQTIME     (F_NXERR+3)      /* Time limit exceeded */
#define EQMSGLONG  (F_NXERR+4)      /* Received message too long for buffer */
#define EQPID      (F_NXERR+5)      /* Invalid ptype */
#define EQNODE     (F_NXERR+6)      /* Invalid node */
#define EQTYPE     (F_NXERR+7)      /* Invalid type */
#define EQMID      (F_NXERR+8)      /* Invalid message id */
#define EQHND      (F_NXERR+9)      /* Invalid handler type */
#define EQNOPROC   (F_NXERR+10)     /* Out of process slots */
#define EQUSEPID   (F_NXERR+11)     /* Ptype already in use */
#define EQNOACT    (F_NXERR+12)     /* No active process */
#define EQBADFIL   (F_NXERR+13)     /* Invalid object file */
#define EQPARAM    (F_NXERR+14)     /* Invalid parameter */
#define EQPFIL     (F_NXERR+15)     /* Invalid file name pointer */
#define EQPCNODE   (F_NXERR+16)     /* Invalid cnode pointer */
#define EQPCPID    (F_NXERR+17)     /* Invalid cpid pointer */
#define EQPCCODE   (F_NXERR+18)     /* Invalid ccode pointer */
#define EQPRIV     (F_NXERR+19)     /* Privileged operation */
#define EQMEM      (F_NXERR+20)     /* Not enough memory */
#define EQNOMID    (F_NXERR+21)     /* Too many requests */
#define EQSET      (F_NXERR+22)     /* Ptype already set */
#define EQNOSET    (F_NXERR+23)     /* No ptype defined */
#define EQUSM      (F_NXERR+24)     /* Invalid diagnostic channel usm id */
#define EQDIM      (F_NXERR+25)     /* Invalid dimension */
#define EQMODE     (F_NXERR+26)     /* Invalid diagnostic channel mode */
#define EQSTATUS   (F_NXERR+27)     /* Invalid diagnostic channel status */
#define EQMSGSHORT (F_NXERR+28)     /* Received message too short for buffer */
#define ECFPS      (F_NXERR+29)     /* Seek to different file pointers */
#define ENFPS      (F_NXERR+30)     /* Different file pointers */
#define EMIXIO     (F_NXERR+31)     /* Mixed file operations */
#define EIMODE     (F_NXERR+32)     /* Bad io mode number */
#define ESETIO     (F_NXERR+33)     /* File is not synchronized */
#define ENOCFS     (F_NXERR+34)     /* No CFS available */
#define EQESIZE    (F_NXERR+35)     /* Invalid size */
#define ERDEOF     (F_NXERR+36)     /* Attempt to read past end of file */
#define EQPATH     (F_NXERR+37)     /* Path name too long */
#define EQTAM      (F_NXERR+38)     /* Max number of applications under debug
                                       was reached. */
#define EQPGRP     (F_NXERR+39)     /* Supplied processes group does not exist
                                       or is under control of another TAM. */
#define EFSNOTSUPP (F_NXERR+40)     /* Operation not supported by this file
                                       system. */



#define F_NXLERR   (F_NXERR+100)    /* Offset of NXLIB error numbers. */
#define ENXLADR    (F_NXLERR+0)     /* Internal error in address database */
#define ENXLENEX   (F_NXLERR+1)     /* Entry does not exist in address
                                       database */
#define ENXLEEX    (F_NXLERR+2)     /* Entry exists already in address
                                       database */
#define ENXLBUF    (F_NXLERR+3)     /* Internal error in buffer layer */
#define ENXLTCPBUF (F_NXLERR+4)     /* Invalid TPC buffer size */
#define ENXLSIU    (F_NXLERR+5)     /* Socket in use by other process */
#define ENXLLMM    (F_NXLERR+6)     /* Location mismatch in address database */
#define ENXLAUK    (F_NXLERR+7)     /* Address unknown */
#define ENXLANS    (F_NXLERR+8)     /* Address set but no socket */

#endif /* __sys_nx_errno_h */



